/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.BaseAccessor;
import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.common.util.StreamUtil;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class LogBundlesAccessor
extends BaseAccessor {
    public static final String ACCESSOR_NAME = "LogBundles";

    public LogBundlesAccessor(HostCredentials hostCredentials) {
        this.setHostCredentials(hostCredentials);
    }

    public String getName() {
        return ACCESSOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() throws Exception {
        EsxServer server;
        block3: {
            block2: {
                server = new EsxServer(this.getHostCredentials());
                String strUrl = server.getLogBundles();
                if (null == strUrl) break block2;
                GZIPInputStream gzis = null;
                try {
                    gzis = this.getZip(server, strUrl);
                    this.processGzip(gzis);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(gzis);
                    throw throwable;
                }
                StreamUtil.close(gzis);
                break block3;
            }
            this.setResult(AccessorResultType.UNAVAILABLE);
        }
        server.close();
    }

    public void processGzip(GZIPInputStream gzis) throws IOException {
        TarInputStream tin = new TarInputStream(gzis);
        TarEntry tarEntry = tin.getNextEntry();
        String parent = null;
        StringBuffer dir = new StringBuffer();
        while (tarEntry != null) {
            String baseName;
            int index;
            if (null == parent) {
                parent = tarEntry.getName();
            }
            String elementName = "";
            if (null != parent) {
                String name = tarEntry.getName();
                String fname = name.substring(parent.length(), name.length());
                elementName = "/" + fname.replace("\\", "/");
            }
            if (elementName.startsWith("/tmp/") && elementName.length() > 5 && !elementName.endsWith(".vpa.txt") && (index = (baseName = elementName.substring(5, elementName.length() - 5)).lastIndexOf(".")) > 0) {
                elementName = baseName.substring(0, index);
            }
            if (elementName.length() > 0 && elementName.charAt(elementName.length() - 1) == '/') {
                elementName = elementName.substring(0, elementName.length() - 1);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tin.copyEntryContents(baos);
            String fileContents = baos.toString();
            ElementCache.getInstance().put(elementName, fileContents);
            String attribs = this.convertMode(tarEntry);
            StringBuffer buf = this.buildFilePermissions(tarEntry, elementName, attribs);
            ElementCache.getInstance().put(elementName + " permissions", buf.toString());
            dir.append(buf);
            dir.append("\n");
            tarEntry = tin.getNextEntry();
        }
        tin.close();
        ElementCache.getInstance().put("LogBundlesFiles", dir.toString());
    }
}

