/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.tandem6530.ModeBase;
import com.mindbright.terminal.tandem6530.ParseException;
import com.mindbright.terminal.tandem6530.Parser;
import com.mindbright.terminal.tandem6530.Screen6530;
import com.mindbright.terminal.tandem6530.Screen6530Buffer;
import com.mindbright.terminal.tandem6530.Terminal6530Callback;

public class ConvMode
extends ModeBase {
    private boolean DEBUG = false;
    private Screen6530 screen;
    private Terminal6530Callback termCallback;
    private Parser parser;
    private boolean halfDuplex = false;
    private int localTransmitColumn = 1;
    private boolean localActionMode = false;
    private char[] enterKeyFunction;
    private DisplayView display;

    public ConvMode(Terminal6530Callback terminal6530Callback, Parser parser) {
        this.termCallback = terminal6530Callback;
        this.parser = parser;
        this.screen = new Screen6530(24, 80, ' ', false);
        this.screen.setSaveLines(400);
    }

    public void setHalfDuplex(boolean bl) {
        this.halfDuplex = bl;
    }

    public void setLocalTransmitColumn(int n) {
        this.localTransmitColumn = n;
    }

    public void setEnterKeyFunction(char[] cArray) {
        this.enterKeyFunction = cArray;
    }

    public void hostChar(char c) {
        this.screen.cursorWrite(c);
        this.repaint();
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
        this.screen.setDisplay(displayView);
    }

    public int getVisTop() {
        return this.screen.getVisTop();
    }

    public void keyHandler(char c, int n, int n2) {
        int n3;
        boolean bl = false;
        switch (n) {
            case 9: {
                this.doTab();
                bl = true;
                break;
            }
            case 10: {
                if ((n2 & 8) == 8) {
                    if (this.localActionMode) {
                        n3 = this.screen.getCursorCol();
                        char[] cArray = this.screen.getCharsAt(this.screen.getScreenTop(), this.screen.getCursorRow());
                        for (int i = this.localTransmitColumn; i < n3; ++i) {
                            this.termCallback.send(cArray[i]);
                        }
                        this.localActionMode = false;
                    } else {
                        this.localActionMode = true;
                    }
                    bl = true;
                    break;
                }
                if ((n2 & 1) == 1 || n2 == 0) {
                    if (this.enterKeyFunction == null) {
                        this.keyHandler('\r', 0, 0);
                    } else {
                        for (n3 = 0; n3 < this.enterKeyFunction.length; ++n3) {
                            this.keyHandler(this.enterKeyFunction[n3], 0, 0);
                        }
                    }
                    this.doCarriageReturn();
                    bl = true;
                    break;
                }
                if ((n2 & 2) != 2) break;
                this.doCursorToLastCharOnRow();
                bl = true;
                break;
            }
            case 36: {
                if ((n2 & 2) == 2) {
                    this.doCursorToLastCharOnScreen();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.doCursorHome();
                bl = true;
                break;
            }
            case 35: {
                if (n2 != 0) break;
                this.doCursorHomeDown();
                bl = true;
                break;
            }
            case 39: {
                if (n2 != 0) break;
                this.doCursorRight();
                bl = true;
                break;
            }
            case 37: {
                if (n2 != 0) break;
                this.doBackspace();
                bl = true;
                break;
            }
            case 38: {
                if ((n2 & 8) == 8) {
                    this.doRollDown();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.doCursorUp();
                bl = true;
                break;
            }
            case 40: {
                if ((n2 & 8) == 8) {
                    this.doRollUp();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.doCursorDown();
                bl = true;
                break;
            }
            case 33: {
                if (n2 != 0) break;
                this.doPageUp();
                bl = true;
                break;
            }
            case 34: {
                if (n2 != 0) break;
                this.doPageDown();
                bl = true;
                break;
            }
            case 49: {
                if ((n2 & 9) == 9) {
                    this.doClearTab();
                    bl = true;
                    break;
                }
                if ((n2 & 8) != 8) break;
                this.doSetTab();
                bl = true;
                break;
            }
            case 50: {
                if ((n2 & 9) == 9) {
                    this.doEraseToEndOfPageOrMemory();
                    bl = true;
                    break;
                }
                if ((n2 & 8) != 8) break;
                this.doEraseToEndOfLineOrField();
                bl = true;
                break;
            }
            case 51: {
                if ((n2 & 8) != 8) break;
                this.doClearAllTabs();
                bl = true;
                break;
            }
            case 52: {
                if ((n2 & 8) != 8) break;
                System.out.println(this.screen.getStatus());
                bl = true;
                break;
            }
        }
        if (bl) {
            return;
        }
        if (c == '\uffff') {
            return;
        }
        if (this.halfDuplex || this.localActionMode) {
            n3 = 256;
            try {
                n3 = this.parser.parse(c);
            }
            catch (ParseException parseException) {
                this.termCallback.error(parseException.getMessage());
                return;
            }
            if (n3 != 256) {
                this.hostChar(c);
            }
        }
        if (!this.localActionMode) {
            this.termCallback.send(c);
        }
    }

    public void switchReset() {
        this.screen.setVisTop(0);
        this.screen.cursorSetPos(0, 0);
        this.screen.clearBelow();
        this.screen.clearAllTabs();
        if (this.display != null) {
            this.display.updateScrollbarValues();
            this.repaint();
        }
    }

    public void doBackspace() {
        this.screen.doBS();
        this.repaint();
    }

    public void doHTab() {
        this.screen.doHTab();
        this.repaint();
    }

    public void doTab() {
        this.termCallback.send(this.screen.spaceToNextTabStop());
    }

    public void doLineFeed() {
        this.screen.cursorDown(1);
        this.repaint();
    }

    public void doCarriageReturn() {
        this.screen.doCR();
        this.repaint();
    }

    public void doSetCursorAddress(boolean bl, int n, int n2) {
        this.screen.cursorSetPos(n - 1, n2 - 1);
        this.repaint();
    }

    public void doSetTab() {
        this.screen.setTab(true);
    }

    public void doClearTab() {
        this.screen.clearTab(true);
    }

    public void doClearAllTabs() {
        this.screen.clearAllTabs();
    }

    public void doSetVideoAttribute(int n) {
        this.screen.setAttribute(n);
        this.repaint();
    }

    public void doSetDefaultVideoAttribute(int n) {
        this.screen.setDefaultAttribute(n);
        this.repaint();
    }

    public void doDefineEnterKeyFunction(char[] cArray) {
        this.enterKeyFunction = cArray;
    }

    public void doCursorToLastCharOnScreen() {
        this.screen.cursorToLastCharOnScreen();
        this.repaint();
    }

    public void doCursorToLastCharOnRow() {
        this.screen.cursorToLastCharOnRow();
        this.repaint();
    }

    public void doCursorUp() {
        this.screen.cursorUp(1);
        this.repaint();
    }

    public void doCursorDown() {
        this.screen.cursorDown(1);
        this.repaint();
    }

    public void doCursorRight() {
        this.screen.cursorForward(1);
        this.repaint();
    }

    public void doCursorHomeDown() {
        int n = this.screen.getLastRow();
        this.screen.setVisTop(n - 24);
        this.screen.cursorSetPos(23, 0);
        this.repaint();
    }

    public void doCursorHome() {
        this.screen.setVisTop(0);
        this.screen.cursorSetPos(0, 0);
        this.repaint();
    }

    public void doRollUp() {
        this.setVisTopDelta(-1);
    }

    public void doRollDown() {
        this.setVisTopDelta(1);
    }

    public void doPageUp() {
        this.setVisTopDelta(-24);
    }

    public void doPageDown() {
        this.setVisTopDelta(24);
    }

    public void doClearMemoryToSpaces() {
        this.doCursorHome();
        this.doEraseToEndOfPageOrMemory();
        this.repaint();
    }

    public void doEraseToEndOfLineOrField() {
        this.screen.clearRight();
        this.repaint();
    }

    public void doEraseToEndOfPageOrMemory() {
        this.screen.clearBelow();
        this.repaint();
    }

    public char[] getChars(int n, int n2) {
        return this.screen.getCharsAt(n, n2);
    }

    public int[] getAttribs(int n, int n2) {
        return this.screen.getAttribsAt(n, n2);
    }

    public int getBufferRows() {
        return this.screen.getTotalLines();
    }

    public int getRow() {
        return this.screen.getCursorRow() + 1;
    }

    public int getCol() {
        return this.screen.getCursorCol() + 1;
    }

    public int getPage() {
        return 1;
    }

    public void doClickSelect(int n, int n2, String string) {
        this.screen.doClickSelect(n, n2, string);
    }

    public void resetClickSelect() {
        this.screen.resetClickSelect();
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.screen.setSelection(n, n2, n3, n4);
    }

    public void selectAll() {
        this.screen.selectAll();
    }

    public void resetSelection() {
        this.screen.resetSelection();
    }

    public String getSelection(String string) {
        return this.screen.getSelection(string);
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        SearchContext searchContext2 = this.screen.search(searchContext, string, bl, bl2);
        if (searchContext2 != null) {
            if (this.display != null) {
                this.display.setVisTop(searchContext2.getStartRow());
            }
            this.screen.setVisTop(searchContext2.getStartRow());
            this.screen.setSelection(searchContext2.getStartRow(), searchContext2.getStartCol(), searchContext2.getEndRow(), searchContext2.getEndCol());
            if (this.display != null) {
                this.display.repaint(true);
            }
        }
        return searchContext2;
    }

    public Screen6530Buffer getBuffer() {
        return this.screen.getBuffer();
    }

    private void repaint() {
        if (this.display != null) {
            this.display.repaint();
        }
    }

    private void setVisTopDelta(int n) {
        int n2 = this.screen.getCursorRow();
        int n3 = this.screen.getCursorCol();
        this.screen.setVisTopDelta(n);
        this.screen.cursorSetPos(n2, n3, true);
        this.repaint();
    }
}

