/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.terminal.CharsetFilter;
import com.mindbright.terminal.DisplayController;
import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.Terminal;
import com.mindbright.terminal.TerminalClipboardHandler;
import com.mindbright.terminal.TerminalDefProps;
import com.mindbright.terminal.TerminalInputListener;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalOption;
import com.mindbright.terminal.TerminalOutputListener;
import com.mindbright.terminal.TerminalPrinter;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.util.RandomSeed;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public final class TerminalWin
extends WindowAdapter
implements TerminalWindow,
DisplayController,
KeyListener {
    static final boolean DEBUG = false;
    static final boolean DEBUGKEYEVENT = false;
    boolean altKeyKludge = false;
    boolean ctrlKeyKludge = false;
    int lastKeyKludge = 0;
    int lastKeyWasEvent = 402;
    Vector inListeners;
    Vector outListeners;
    TerminalPrinter printer;
    boolean printerActive;
    TerminalClipboardHandler clipboard;
    Frame ownerFrame;
    Object writeLock;
    CharsetFilter filter;
    boolean dumbMode = false;
    static final char[] mc4;
    int mc4MatchIdx;
    private int popupButton = 4;
    private int pasteButton = 8;
    TerminalMenuHandler menuHandler;
    String title = null;
    Properties props;
    boolean propsChanged;
    String savedGeomPos;
    boolean insideConstructor;
    int vpixels;
    int hpixels;
    int selectRowAnchor;
    int selectColAnchor;
    int selectRowLast;
    int selectColLast;
    int selectVisTop;
    boolean hasSelection;
    boolean selectReverse;
    String selectDelims;
    int selectClickRow = -1;
    boolean selectClickState;
    long lastLeftClick = 0L;
    Color origBgColor;
    Color origFgColor;
    Color cursorColor;
    public static final Color[] termColors;
    public static final String[] termColorNames;
    private static final int ATTR_CHARNOTDRAWN = 0;
    private static final int ATTR_LINEDRAW = 256;
    private static final int ATTR_SELECTED = 4096;
    private static final int ATTR_CHARDRAWN = 32768;
    private static final int MASK_ATTR = 65535;
    private static final int MASK_FGCOL = 0xFF0000;
    private static final int MASK_BGCOL = -16777216;
    private static final int SHIFT_FGCOL = 16;
    private static final int SHIFT_BGCOL = 24;
    private static final char[] byte2char;
    private static TerminalOption optPassthruPrint;
    private static TerminalOption optCopyCrNl;
    private static TerminalOption optCopySelect;
    private static TerminalOption optEncoding;
    private static TerminalOption optFontName;
    private static TerminalOption optFontSize;
    private static TerminalOption optGeometry;
    private static TerminalOption optTermType;
    private static TerminalOption optSaveLines;
    private static TerminalOption optScrollBar;
    private static TerminalOption optBgColor;
    private static TerminalOption optFgColor;
    private static TerminalOption optCursorColor;
    private static TerminalOption optSelectDelim;
    private static TerminalOption optPaseButton;
    private static TerminalOption optInputCharset;
    private static TerminalOption optLineSpaceDelta;
    private static TerminalOption optKeyKludge;
    private static TerminalOption[] optionsDef;
    private static TerminalOption[] settingsDef;
    private static String[] obsoleteOptions;
    private static Properties defaultProperties;
    private static String[] propertyNames;
    private static Class[] terminalList;
    private boolean[] termOptions = new boolean[OPT_LAST_OPT];
    private static int OPT_PASSTHRU_PRN;
    private static int OPT_COPY_SEL;
    private static int OPT_KEY_KLUDGE;
    private static int OPT_LAST_OPT;
    private String copyEol;
    private DisplayView display;
    private Terminal terminal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Frame;

    private static Terminal getTerminal(String string) {
        Terminal terminal = null;
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TerminalWin.class$("java.lang.String")) : class$java$lang$String};
        Object[] objectArray = new Object[]{string};
        for (int i = 0; i < terminalList.length; ++i) {
            if (terminalList[i] == null) continue;
            try {
                Method method = terminalList[i].getMethod("getTerminal", classArray);
                terminal = (Terminal)method.invoke(null, objectArray);
                if (terminal == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return terminal;
    }

    public static String[] getTerminalTypes() {
        String[] stringArray = new String[]{};
        for (int i = 0; i < terminalList.length; ++i) {
            if (terminalList[i] == null) continue;
            try {
                Method method = terminalList[i].getMethod("getTerminalTypes", null);
                String[] stringArray2 = (String[])method.invoke(null, (Object[])null);
                if (stringArray2 == null) continue;
                String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                stringArray = stringArray3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private static TerminalOption[] getTerminalsOptions() {
        TerminalOption[] terminalOptionArray = new TerminalOption[]{};
        for (int i = 0; i < terminalList.length; ++i) {
            if (terminalList[i] == null) continue;
            try {
                Method method = terminalList[i].getMethod("getTerminalOptions", null);
                TerminalOption[] terminalOptionArray2 = (TerminalOption[])method.invoke(null, (Object[])null);
                if (terminalOptionArray2 == null) continue;
                TerminalOption[] terminalOptionArray3 = new TerminalOption[terminalOptionArray.length + terminalOptionArray2.length];
                System.arraycopy(terminalOptionArray, 0, terminalOptionArray3, 0, terminalOptionArray.length);
                System.arraycopy(terminalOptionArray2, 0, terminalOptionArray3, terminalOptionArray.length, terminalOptionArray2.length);
                terminalOptionArray = terminalOptionArray3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return terminalOptionArray;
    }

    public TerminalWin(Frame frame) throws IllegalArgumentException, NoSuchElementException {
        this(frame, defaultProperties);
    }

    public TerminalWin(Frame frame, Properties properties) throws IllegalArgumentException {
        this(frame, properties, false);
    }

    public TerminalWin(Frame frame, Properties properties, boolean bl) throws IllegalArgumentException {
        Object object;
        Object object2;
        this.writeLock = new Object();
        this.terminal = TerminalWin.getTerminal("xterm");
        if (bl) {
            object2 = ((Hashtable)properties).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string = properties.getProperty((String)object);
                object = TerminalDefProps.backwardCompatProp((String)object);
                ((Hashtable)defaultProperties).put(object, string);
            }
        }
        this.savedGeomPos = "";
        this.ownerFrame = frame;
        try {
            object2 = Class.forName(AWTConvenience.isSwingJFrame(frame) ? "com.mindbright.terminal.DisplaySwing" : "com.mindbright.terminal.DisplayAWT");
            object = ((Class)object2).getConstructor(class$java$awt$Frame == null ? (class$java$awt$Frame = TerminalWin.class$("java.awt.Frame")) : class$java$awt$Frame);
            this.display = (DisplayView)((Constructor)object).newInstance(frame);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        frame.addWindowListener(this);
        this.display.setController(this);
        this.display.setKeyListener(this);
        this.terminal.setDisplay(this.display);
        this.terminal.setTerminalWindow(this);
        this.insideConstructor = true;
        this.setProperties(properties, true);
        this.insideConstructor = false;
        this.propsChanged = false;
    }

    public void emulateComponentShown() {
        this.display.emulateComponentShown();
    }

    public void requestFocus() {
        this.display.requestFocus();
    }

    public void setMenus(TerminalMenuHandler terminalMenuHandler) {
        this.menuHandler = terminalMenuHandler;
    }

    public TerminalMenuHandler getMenus() {
        return this.menuHandler;
    }

    public DisplayView getDisplay() {
        return this.display;
    }

    public void updateMenus() {
        if (this.menuHandler != null) {
            this.menuHandler.update();
        }
    }

    public void setLogo(Image image, int n, int n2, int n3, int n4) {
        this.display.setLogo(image, n, n2, n3, n4);
    }

    public Image getLogo() {
        return this.display.getLogo();
    }

    public boolean showLogo() {
        return this.display.showLogo();
    }

    public void hideLogo() {
        this.display.hideLogo();
    }

    public void setProperties(Properties properties, boolean bl) throws IllegalArgumentException {
        int n;
        String string;
        String string2;
        Object object;
        Properties properties2 = this.props;
        this.props = new Properties(defaultProperties);
        if (bl && properties2 != null) {
            object = ((Hashtable)properties2).keys();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                string = properties2.getProperty(string2);
                ((Hashtable)this.props).put(string2, string);
            }
        }
        for (n = 0; n < settingsDef.length; ++n) {
            string2 = settingsDef[n].getKey();
            string = properties.getProperty(string2);
            string2 = TerminalDefProps.backwardCompatProp(string2);
            if (string == null) {
                string = this.props.getProperty(string2);
            }
            if (!bl && properties2 != null) {
                object = properties2.getProperty(string2);
                this.setProperty(string2, string, !string.equals(object));
                continue;
            }
            this.setProperty(string2, string, this.insideConstructor);
        }
        for (n = 0; n < optionsDef.length; ++n) {
            string2 = optionsDef[n].getKey();
            string = properties.getProperty(string2);
            string2 = TerminalDefProps.backwardCompatProp(string2);
            if (string == null) {
                string = this.props.getProperty(string2);
            }
            if (!bl && properties2 != null) {
                object = properties2.getProperty(string2);
                this.setProperty(string2, string, !string.equals(object));
                continue;
            }
            this.setProperty(string2, string, this.insideConstructor);
        }
        TerminalOption[] terminalOptionArray = this.terminal.getOptions();
        for (n = 0; n < terminalOptionArray.length; ++n) {
            string2 = terminalOptionArray[n].getKey();
            string = properties.getProperty(string2);
            string2 = TerminalDefProps.backwardCompatProp(string2);
            if (string == null) {
                string = this.props.getProperty(string2);
            }
            if (!bl && properties2 != null) {
                object = properties2.getProperty(string2);
                this.setProperty(string2, string, !string.equals(object));
                continue;
            }
            this.setProperty(string2, string, this.insideConstructor);
        }
    }

    private static Properties propertiesUnion(Properties properties, Properties properties2) {
        String string;
        Enumeration enumeration;
        Properties properties3;
        Properties properties4 = new Properties();
        if (properties != null) {
            properties3 = properties;
            enumeration = ((Hashtable)properties3).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((Hashtable)properties4).put(string, properties3.getProperty(string));
            }
        }
        if (properties2 != null) {
            properties3 = properties2;
            enumeration = ((Hashtable)properties3).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((Hashtable)properties4).put(string, properties3.getProperty(string));
            }
        }
        return properties4;
    }

    public Properties getProperties() {
        return TerminalWin.propertiesUnion(this.props, this.terminal.getProperties());
    }

    public boolean getPropsChanged() {
        return this.propsChanged || this.terminal.getPropsChanged();
    }

    public void setPropsChanged(boolean bl) {
        this.terminal.setPropsChanged(bl);
        this.propsChanged = bl;
    }

    public static boolean isProperty(String string) {
        if (((Hashtable)defaultProperties).containsKey(string)) {
            return true;
        }
        for (int i = 0; i < obsoleteOptions.length; ++i) {
            if (!string.equals(obsoleteOptions[i])) continue;
            return true;
        }
        return false;
    }

    public void resetToDefaults() {
        this.setProperties(defaultProperties, false);
    }

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public String getProperty(String string) {
        String string2 = this.terminal.getProperty(string = TerminalDefProps.backwardCompatProp(string));
        if (string2 != null) {
            return string2;
        }
        return this.props.getProperty(string);
    }

    public String getDefaultProperty(String string) {
        String string2 = this.terminal.getDefaultProperty(string = TerminalDefProps.backwardCompatProp(string));
        if (string2 != null) {
            return string2;
        }
        return defaultProperties.getProperty(string);
    }

    public void resetProperty(String string) {
        string = TerminalDefProps.backwardCompatProp(string);
        this.setProperty(string, this.getDefaultProperty(string));
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        this.setProperty(string, string2, false);
    }

    public TerminalOption[] getOptions() {
        int n;
        TerminalOption[] terminalOptionArray = this.terminal.getOptions();
        TerminalOption[] terminalOptionArray2 = new TerminalOption[optionsDef.length + terminalOptionArray.length];
        for (n = 0; n < optionsDef.length; ++n) {
            terminalOptionArray2[n] = optionsDef[n].copy();
        }
        for (n = 0; n < terminalOptionArray.length; ++n) {
            terminalOptionArray2[TerminalWin.optionsDef.length + n] = terminalOptionArray[n].copy();
        }
        for (n = 0; n < terminalOptionArray2.length; ++n) {
            terminalOptionArray2[n].setValue(this.getProperty(terminalOptionArray2[n].getKey()));
        }
        return terminalOptionArray2;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setProperty(String var1_1, String var2_2, boolean var3_3) throws IllegalArgumentException, NoSuchElementException {
        block36: {
            block38: {
                block49: {
                    block48: {
                        block46: {
                            block47: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block39: {
                                                            block37: {
                                                                var4_4 = false;
                                                                var1_1 = TerminalDefProps.backwardCompatProp(var1_1);
                                                                if (this.terminal == null || this.terminal.setProperty(var1_1, var2_2, true)) break block36;
                                                                var5_5 = this.props.getProperty(var1_1);
                                                                if (var5_5 != null && var5_5.equals(var2_2)) {
                                                                    var4_4 = true;
                                                                    if (!var3_3) {
                                                                        return;
                                                                    }
                                                                }
                                                                var6_6 = Boolean.valueOf(var2_2);
                                                                if (!var1_1.equals(TerminalWin.optPassthruPrint.getKey())) break block37;
                                                                this.termOptions[TerminalWin.OPT_PASSTHRU_PRN] = var6_6;
                                                                break block38;
                                                            }
                                                            if (!var1_1.equals(TerminalWin.optCopyCrNl.getKey())) break block39;
                                                            this.copyEol = var6_6 ? "\r\n" : "\r";
                                                            break block38;
                                                        }
                                                        if (!var1_1.equals(TerminalWin.optCopySelect.getKey())) break block40;
                                                        this.termOptions[TerminalWin.OPT_COPY_SEL] = var6_6;
                                                        break block38;
                                                    }
                                                    if (!var1_1.equals(TerminalWin.optKeyKludge.getKey())) break block41;
                                                    this.termOptions[TerminalWin.OPT_KEY_KLUDGE] = var6_6;
                                                    break block38;
                                                }
                                                if (!var1_1.equals(TerminalWin.optTermType.getKey())) break block42;
                                                if (!this.terminal.terminalType().equals(var2_2)) {
                                                    if (!this.terminal.setTerminalType(var2_2)) {
                                                        var7_7 = TerminalWin.getTerminal(var2_2);
                                                        if (var7_7 == null) {
                                                            throw new IllegalArgumentException("terminal type '" + var2_2 + "' unknown");
                                                        }
                                                        this.terminal = var7_7;
                                                    }
                                                    this.terminal.setDisplay(this.display);
                                                    this.terminal.setTerminalWindow(this);
                                                    this.terminal.reset();
                                                    this.setProperty(TerminalWin.optSaveLines.getKey(), this.getProperty(TerminalWin.optSaveLines.getKey()), true);
                                                    if (this.inListeners != null) {
                                                        var7_8 = this.inListeners.size();
                                                        for (var8_16 = 0; var8_16 < var7_8; ++var8_16) {
                                                            var9_19 = (TerminalInputListener)this.inListeners.elementAt(var8_16);
                                                            if (var9_19 == null) continue;
                                                            var9_19.signalTermTypeChanged(var2_2);
                                                        }
                                                    }
                                                }
                                                break block38;
                                            }
                                            if (!var1_1.equals(TerminalWin.optEncoding.getKey())) break block43;
                                            try {
                                                var7_9 = Class.forName("com.mindbright.terminal.filter.Filter");
                                                var8_17 = var7_9.getMethod("create", new Class[]{TerminalWin.class$java$lang$String == null ? (TerminalWin.class$java$lang$String = TerminalWin.class$("java.lang.String")) : TerminalWin.class$java$lang$String});
                                                this.filter = (CharsetFilter)var8_17.invoke(null, new Object[]{var2_2});
                                                if (null != this.filter) ** GOTO lbl134
                                                throw new IllegalArgumentException("Encoding not supported");
                                            }
                                            catch (IllegalArgumentException var7_10) {
                                                throw var7_10;
                                            }
                                            catch (Throwable var7_11) {
                                                System.out.println("System has no support for encodings");
                                            }
                                            break block38;
                                        }
                                        if (!var1_1.equals(TerminalWin.optFontName.getKey())) break block44;
                                        this.setFont(var2_2, Integer.parseInt(this.getProperty(TerminalWin.optFontSize.getKey())));
                                        break block38;
                                    }
                                    if (var1_1.equals(TerminalWin.optFontSize.getKey())) {
                                        try {
                                            this.setFont(this.getProperty(TerminalWin.optFontName.getKey()), Integer.parseInt(var2_2));
                                        }
                                        catch (NumberFormatException var7_12) {
                                            throw new IllegalArgumentException("value for '" + var1_1 + "' must be an integer");
                                        }
                                    }
                                    if (!var1_1.equals(TerminalWin.optSaveLines.getKey())) break block45;
                                    try {
                                        var7_13 = Integer.parseInt(var2_2);
                                        if (var7_13 < 0 || var7_13 > 8192) {
                                            throw new NumberFormatException();
                                        }
                                        if (this.terminal.setSaveLines(var7_13)) ** GOTO lbl134
                                        this.write("\n\rOut of memory allocating scrollback buffer!");
                                    }
                                    catch (NumberFormatException var7_14) {
                                        throw new IllegalArgumentException("value for '" + var1_1 + "' must be an integer (0-8192)");
                                    }
                                }
                                if (!var1_1.equals(TerminalWin.optScrollBar.getKey())) break block46;
                                if (!var2_2.equals("left") && !var2_2.equals("right") && !var2_2.equals("none")) break block47;
                                this.display.moveScrollbar(var2_2);
                                this.updateScrollbarValues();
                                break block38;
                            }
                            throw new IllegalArgumentException("scrollbar can be right, left or none");
                        }
                        if (!var1_1.equals("bg-color") && !var1_1.equals("fg-color") && !var1_1.equals("cursor-color")) break block48;
                        try {
                            var7_15 = Character.isDigit(var2_2.charAt(0)) ? TerminalWin.getTermRGBColor(var2_2) : TerminalWin.getTermColor(var2_2);
                        }
                        catch (NumberFormatException var8_18) {
                            throw new IllegalArgumentException("valid colors: 'color-name' or '<r>,<g>,<b>'");
                        }
                        if (var1_1.equals("bg-color")) {
                            this.origBgColor = var7_15;
                            this.display.setBackgroundColor(this.origBgColor);
                        } else if (var1_1.equals("cursor-color")) {
                            this.display.setCursorColor(var7_15);
                        } else {
                            this.origFgColor = var7_15;
                            this.display.setForegroundColor(this.origFgColor);
                        }
                        break block38;
                    }
                    if (var1_1.equals("resize-gravity")) {
                        return;
                    }
                    if (var1_1.equals(TerminalWin.optGeometry.getKey())) {
                        this.setGeometry(var2_2);
                        return;
                    }
                    if (!var1_1.equals(TerminalWin.optSelectDelim.getKey())) break block49;
                    if (var2_2.charAt(0) != '\"' || var2_2.charAt(var2_2.length() - 1) != '\"') {
                        var2_2 = "\"" + var2_2 + "\"";
                    }
                    this.selectDelims = var2_2.substring(1, var2_2.length());
                    break block38;
                }
                if (!var1_1.equals(TerminalWin.optPaseButton.getKey())) ** GOTO lbl127
                if (var2_2.equals("middle")) {
                    this.pasteButton = 8;
                } else if (var2_2.equals("right")) {
                    this.pasteButton = 4;
                } else if (var2_2.equals("shift+left")) {
                    this.pasteButton = 17;
                } else {
                    throw new IllegalArgumentException("mouse paste button can be 'middle' or 'right'");
lbl127:
                    // 1 sources

                    if (var1_1.equals(TerminalWin.optInputCharset.getKey())) {
                        this.setInputCharset(var2_2);
                    } else if (var1_1.equals(TerminalWin.optLineSpaceDelta.getKey())) {
                        this.display.setLineSpaceDelta(Integer.parseInt(var2_2));
                    } else {
                        throw new NoSuchElementException("unknown terminal-property '" + var1_1 + "'");
                    }
                }
            }
            this.props.put(var1_1, var2_2);
        }
        if (!var4_4 || this.terminal.getPropsChanged()) {
            this.propsChanged = true;
            this.updateMenus();
        }
    }

    public static Color getTermRGBColor(String string) throws NumberFormatException {
        int n = string.indexOf(44);
        int n2 = string.lastIndexOf(44);
        if (n == -1 || n2 == -1) {
            throw new NumberFormatException();
        }
        int n3 = Integer.parseInt(string.substring(0, n).trim());
        int n4 = Integer.parseInt(string.substring(n + 1, n2).trim());
        int n5 = Integer.parseInt(string.substring(n2 + 1).trim());
        Color color = new Color(n3, n4, n5);
        return color;
    }

    public static Color getTermColor(String string) throws IllegalArgumentException {
        int n;
        for (n = 0; n < termColors.length && !termColorNames[n].equalsIgnoreCase(string); ++n) {
        }
        if (n == termColors.length) {
            throw new IllegalArgumentException("Unknown color: " + string);
        }
        return termColors[n];
    }

    public void setGeometry(String string) throws IllegalArgumentException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf(120);
        try {
            if (n5 == -1) {
                throw new Exception();
            }
            int n6 = string.indexOf(43);
            int n7 = string.indexOf(45);
            if (n7 != -1) {
                n6 = n6 > n7 || n6 == -1 ? n7 : n6;
            }
            n2 = Integer.parseInt(string.substring(0, n5).trim());
            n = Integer.parseInt(string.substring(n5 + 1, n6 == -1 ? string.length() : n6).trim());
            if (n6 != -1) {
                n7 = string.indexOf(43, n6 + 1);
                if (n7 == -1 && (n7 = string.indexOf(45, n6 + 1)) == -1) {
                    throw new Exception();
                }
                n3 = Integer.parseInt(string.substring(n6 + 1, n7).trim());
                n4 = Integer.parseInt(string.substring(n7 + 1).trim());
                this.savedGeomPos = string.substring(n6).trim();
            } else {
                this.savedGeomPos = "";
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("geometry must be '<cols>x<rows>[pos]', e.g. '80x24+0-0'");
        }
        if (this.terminal.setSize(n, n2)) {
            this.display.setPosition(n3, n4);
        }
    }

    public void setFont(String string, int n) {
        this.display.setFont(string, n);
    }

    public void setFont(Font font) {
        this.display.setFont(font.getName(), font.getSize());
    }

    public void setTitle(String string) {
        if (string != null && !string.equals(this.title)) {
            this.title = string;
            this.signalWindowChanged(this.terminal.getRows(), this.terminal.getCols(), this.vpixels, this.hpixels);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setPopupButton(int n) {
        switch (n) {
            case 1: {
                this.popupButton = 16;
                break;
            }
            case 2: {
                this.popupButton = 8;
                break;
            }
            case 3: {
                this.popupButton = 4;
                break;
            }
        }
    }

    void updateScrollbarValues() {
        this.display.updateScrollbarValues();
    }

    public Container getPanelWithScrollbar() {
        return this.display.getPanelWithScrollbar(this.getProperty("scrollbar"));
    }

    public void clearSaveLines() {
        this.terminal.clearSaveLines();
    }

    public void setInputCharset(String string) throws IllegalArgumentException {
        this.terminal.setInputCharset(string);
    }

    public String terminalType() {
        return this.terminal.terminalType();
    }

    public int rows() {
        return this.terminal.getRows();
    }

    public int cols() {
        return this.terminal.getCols();
    }

    public int vpixels() {
        return this.vpixels;
    }

    public int hpixels() {
        return this.hpixels;
    }

    public void write(byte by) {
        if (this.filter != null) {
            this.write(this.filter.convertFrom(by));
        } else {
            this.write((char)by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char c) {
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            if (this.outListeners != null) {
                n = this.outListeners.size();
                for (int i = 0; i < n; ++i) {
                    TerminalOutputListener terminalOutputListener = (TerminalOutputListener)this.outListeners.elementAt(i);
                    if (terminalOutputListener == null) continue;
                    terminalOutputListener.write(c);
                }
            }
            if (this.printerActive) {
                if (mc4[this.mc4MatchIdx] == c) {
                    ++this.mc4MatchIdx;
                    this.mc4MatchIdx %= 4;
                } else {
                    if (this.mc4MatchIdx > 0) {
                        for (n = 0; n < this.mc4MatchIdx; ++n) {
                            this.printer.write(mc4[n]);
                        }
                        this.mc4MatchIdx = 0;
                    }
                    this.printer.write(c);
                }
            }
            this.terminal.fromHost(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.writeLock;
        synchronized (object) {
            this.terminal.setUpdate(false);
            int n3 = n + n2;
            for (int i = n; i < n3 - 1; ++i) {
                this.write(cArray[i]);
            }
            this.terminal.setUpdate(true);
            if (n3 > 0) {
                this.write(cArray[n3 - 1]);
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.filter != null) {
            this.write(this.filter.convertFrom(byArray, n, n2));
        } else {
            this.writeInt(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInt(byte[] byArray, int n, int n2) {
        Object object = this.writeLock;
        synchronized (object) {
            this.terminal.setUpdate(false);
            int n3 = n + n2;
            for (int i = n; i < n3 - 1; ++i) {
                this.write(byte2char[byArray[i] & 0xFF]);
            }
            this.terminal.setUpdate(true);
            if (n3 > 0) {
                this.write(byte2char[byArray[n3 - 1] & 0xFF]);
            }
        }
    }

    public void write(String string) {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    public void addInputListener(TerminalInputListener terminalInputListener) {
        if (this.inListeners == null) {
            this.inListeners = new Vector();
        }
        this.inListeners.removeElement(terminalInputListener);
        this.inListeners.addElement(terminalInputListener);
    }

    public void removeInputListener(TerminalInputListener terminalInputListener) {
        if (this.inListeners != null) {
            this.inListeners.removeElement(terminalInputListener);
            if (this.inListeners.size() == 0) {
                this.inListeners = null;
            }
        }
    }

    public void addOutputListener(TerminalOutputListener terminalOutputListener) {
        if (this.outListeners == null) {
            this.outListeners = new Vector();
        }
        this.outListeners.removeElement(terminalOutputListener);
        this.outListeners.addElement(terminalOutputListener);
    }

    public void removeOutputListener(TerminalOutputListener terminalOutputListener) {
        if (this.outListeners != null) {
            this.outListeners.removeElement(terminalOutputListener);
            if (this.outListeners.size() == 0) {
                this.outListeners = null;
            }
        }
    }

    public void attachPrinter(TerminalPrinter terminalPrinter) {
        this.printer = terminalPrinter;
    }

    public void detachPrinter() {
        this.printer = null;
    }

    public void setClipboard(TerminalClipboardHandler terminalClipboardHandler) {
        this.clipboard = terminalClipboardHandler;
        String string = this.terminal.getSelection(this.copyEol);
        if (string != null) {
            terminalClipboardHandler.setSelection(string);
        } else {
            terminalClipboardHandler.clearSelection();
        }
    }

    public TerminalClipboardHandler getClipboard() {
        return this.clipboard;
    }

    public void typedChar(char c) {
        if (this.filter != null && !this.dumbMode) {
            byte[] byArray = this.filter.convertTo(c);
            if (byArray.length > 0) {
                this.sendBytesInt(byArray);
            }
        } else {
            this.typedCharInt(c);
        }
    }

    public void typedCharInt(char c) {
        if (this.inListeners != null) {
            int n = this.inListeners.size();
            for (int i = 0; i < n; ++i) {
                TerminalInputListener terminalInputListener = (TerminalInputListener)this.inListeners.elementAt(i);
                if (terminalInputListener == null) continue;
                terminalInputListener.typedChar(c);
            }
        }
    }

    public final void sendBytes(byte[] byArray) {
        if (this.filter != null && !this.dumbMode) {
            if ((byArray = this.filter.convertTo(byArray)).length > 0) {
                this.sendBytesInt(byArray);
            }
        } else {
            this.sendBytesInt(byArray);
        }
    }

    public final void sendBytesInt(byte[] byArray) {
        if (this.inListeners != null) {
            int n = this.inListeners.size();
            for (int i = 0; i < n; ++i) {
                TerminalInputListener terminalInputListener = (TerminalInputListener)this.inListeners.elementAt(i);
                if (terminalInputListener == null) continue;
                terminalInputListener.sendBytes(byArray);
            }
        }
    }

    public final void sendBreak() {
        if (this.inListeners != null) {
            int n = this.inListeners.size();
            for (int i = 0; i < n; ++i) {
                TerminalInputListener terminalInputListener = (TerminalInputListener)this.inListeners.elementAt(i);
                if (terminalInputListener == null) continue;
                terminalInputListener.sendBreak();
            }
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.inListeners != null) {
            int n5 = this.inListeners.size();
            for (int i = 0; i < n5; ++i) {
                TerminalInputListener terminalInputListener = (TerminalInputListener)this.inListeners.elementAt(i);
                if (terminalInputListener == null) continue;
                terminalInputListener.signalWindowChanged(n, n2, n3, n4);
            }
        }
    }

    public void reset() {
        this.terminal.reset();
    }

    public void printScreen() {
        if (this.printer != null && this.termOptions[OPT_PASSTHRU_PRN]) {
            this.printer.printScreen();
        }
    }

    public void startPrinter() {
        if (this.printer != null && this.termOptions[OPT_PASSTHRU_PRN]) {
            this.printer.startPrinter();
            this.printerActive = true;
        }
    }

    public void stopPrinter() {
        if (this.printer != null && this.termOptions[OPT_PASSTHRU_PRN]) {
            this.printerActive = false;
            this.printer.stopPrinter();
        }
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        return this.terminal.search(searchContext, string, bl, bl2);
    }

    private char keyKludgeFilter(char n, int n2, int n3) {
        int n4 = n;
        if (n2 == 16 || n2 == 17 || n2 == 20 || n2 == 18) {
            return '\uffff';
        }
        if ((n3 & 2) != 0 && (n3 & 8) != 0) {
            return '\uffff';
        }
        if ((n3 & 2) != 0) {
            if (n2 == 77) {
                n4 = 13;
            } else if (n2 == 0) {
                if (n == 32 || n == 64) {
                    n4 = 0;
                } else if (n == 91) {
                    n4 = 27;
                } else if (n == 92) {
                    n4 = 28;
                } else if (n == 93) {
                    n4 = 29;
                } else if (n == 94 || n == 126 || n == 96) {
                    n4 = 30;
                } else if (n == 95 || n == 63) {
                    n4 = 31;
                }
            }
        } else if (n4 == 10 && !this.ctrlKeyKludge) {
            n4 = 13;
        } else if (n == 65535) {
            n4 = 65535;
        } else if (n == 65406) {
            n4 = 65535;
        }
        return (char)n4;
    }

    public void displayDragResize(int n, int n2) {
        this.terminal.setSize(n, n2);
    }

    public void displayResized(int n, int n2, int n3, int n4) {
        this.signalWindowChanged(n, n2, n3, n4);
        String string = n2 + "x" + n + this.savedGeomPos;
        this.propsChanged = true;
        ((Hashtable)this.props).put("geometry", string);
        this.updateMenus();
    }

    public void selectAll() {
        this.terminal.selectAll();
        if (this.termOptions[OPT_COPY_SEL]) {
            this.doCopy();
        }
    }

    public void clearSelection() {
        if (!this.hasSelection) {
            return;
        }
        if (this.clipboard != null) {
            this.clipboard.clearSelection();
        }
        this.terminal.resetSelection();
        this.hasSelection = false;
    }

    public String getSelection() {
        return this.terminal.getSelection(this.copyEol);
    }

    public void doCopy() {
        if (this.clipboard != null) {
            this.clipboard.setSelection(this.getSelection());
        }
    }

    public void doPaste() {
        if (this.clipboard != null) {
            this.terminal.paste(this.clipboard.getSelection());
        }
    }

    public void setDumbMode(boolean bl) {
        this.terminal.setDumbMode(bl);
        this.dumbMode = bl;
    }

    public void setIgnoreClose() {
        this.display.setIgnoreClose();
    }

    public void mouseClicked(int n, int n2, int n3, int n4, int n5) {
        if (this.inListeners != null && n4 == this.pasteButton) {
            this.doPaste();
        }
        if ((n4 & 0x17) == 16) {
            this.display.requestFocus();
        }
    }

    public void mousePressed(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        long l = System.currentTimeMillis();
        if (n5 == 2 && this.pasteButton != 4) {
            this.selectRowLast = n2;
            this.selectColLast = n3;
            this.terminal.setSelection(this.selectVisTop + this.selectRowAnchor, this.selectColAnchor, n + this.selectRowLast, this.selectColLast);
            this.hasSelection = true;
            if (this.termOptions[OPT_COPY_SEL]) {
                this.doCopy();
            }
        } else {
            this.clearSelection();
            this.selectRowAnchor = n2;
            this.selectColAnchor = n3;
            this.selectRowLast = n2;
            this.selectColLast = n3;
            this.selectVisTop = n;
        }
        if (l - this.lastLeftClick < 250L) {
            this.terminal.doClickSelect(n, n2, n3, this.selectDelims);
            this.hasSelection = true;
        } else {
            this.terminal.resetClickSelect();
        }
        this.lastLeftClick = l;
        if (n4 == (this.popupButton | 2)) {
            this.ctrlKeyKludge = false;
            this.menuHandler.showPopupMenu(n6, n7);
        }
        this.terminal.mouseHandler(n, n2, n3, true, n4);
    }

    public void mouseReleased(int n, int n2, int n3, int n4, int n5) {
        if ((n4 & 0x17) == 16 && this.hasSelection && this.termOptions[OPT_COPY_SEL]) {
            this.doCopy();
        }
        this.terminal.mouseHandler(n, n2, n3, false, n4);
    }

    public void mouseDragged(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.hasSelection && this.selectRowLast == n2 && this.selectColLast == n3 && n6 == 0) {
            return;
        }
        this.selectRowAnchor += n6;
        this.selectRowLast = n2;
        this.selectColLast = n3;
        this.terminal.setSelection(n, this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
        this.hasSelection = true;
    }

    public void scrollUp() {
        this.display.setVisTopDelta(-1, true);
    }

    public void scrollDown() {
        this.display.setVisTopDelta(1, true);
    }

    private boolean isNewKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.lastKeyWasEvent != keyEvent.getID()) {
            if (c == this.lastKeyKludge) {
                return false;
            }
            if (this.lastKeyKludge == 10 && c == '\r' || this.lastKeyKludge == 13 && c == '\n' || this.lastKeyKludge == 8 && c == '\u007f') {
                return false;
            }
        }
        this.lastKeyKludge = c;
        this.lastKeyWasEvent = keyEvent.getID();
        return true;
    }

    private void processKey(KeyEvent keyEvent) {
        if (!this.isNewKeyEvent(keyEvent)) {
            return;
        }
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        switch (n) {
            case 9: 
            case 121: {
                keyEvent.consume();
                break;
            }
            case 155: {
                if ((n2 & 1) != 0) {
                    this.doPaste();
                    return;
                }
                if ((n2 & 2) == 0) break;
                this.doCopy();
                return;
            }
            case 18: {
                if (this.ctrlKeyKludge) {
                    this.ctrlKeyKludge = false;
                } else {
                    this.altKeyKludge = true;
                }
                return;
            }
            case 17: {
                this.ctrlKeyKludge = true;
                return;
            }
            case 16: 
            case 20: {
                return;
            }
        }
        if ((n2 & 4) != 0) {
            if (c == 'c') {
                this.doCopy();
                return;
            }
            if (c == 'v') {
                this.doPaste();
                return;
            }
        }
        char c2 = c;
        c = this.keyKludgeFilter(c, n, n2);
        if (this.termOptions[OPT_KEY_KLUDGE]) {
            n2 &= 0xFFFFFFFD;
            if (this.ctrlKeyKludge) {
                n2 |= 2;
            }
            n2 &= 0xFFFFFFF7;
            if (this.altKeyKludge) {
                n2 |= 8;
            }
        }
        this.terminal.keyHandler(c, n, n2);
    }

    public void addAsEntropyGenerator(RandomSeed randomSeed) {
        randomSeed.addEntropyGenerator(this.display.getAWTComponent());
    }

    public void setAttributeBold(boolean bl) {
        this.terminal.setAttributeBold(bl);
    }

    public void clearScreen() {
        this.terminal.clearScreen();
    }

    public void ringBell() {
        this.terminal.ringBell();
    }

    public void setCursorPos(int n, int n2) {
        this.terminal.setCursorPos(n, n2);
    }

    public void clearLine() {
        this.terminal.clearLine();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.display.windowClosed();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 9: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 127: 
            case 155: {
                this.processKey(keyEvent);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        this.processKey(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        switch (n) {
            case 18: {
                this.altKeyKludge = false;
                break;
            }
            case 17: {
                this.ctrlKeyKludge = false;
                break;
            }
            case 135: {
                if (n2 == 0 || (n2 & 1) != 0) break;
                this.terminal.keyHandler('~', n, n2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        mc4 = new char[]{'\u001b', '[', '4', 'i'};
        termColors = new Color[]{Color.black, Color.red.darker(), Color.green.darker(), Color.yellow.darker(), Color.blue.darker(), Color.magenta.darker(), Color.cyan.darker(), Color.white, Color.darkGray, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
        termColorNames = new String[]{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", "i_black", "i_red", "i_green", "i_yellow", "i_blue", "i_magenta", "i_cyan", "i_white"};
        byte2char = new char[256];
        optPassthruPrint = new TerminalOption("passthru-prn-enable", "Enable Passthrough Print", "true");
        optCopyCrNl = new TerminalOption("copy-crnl", "Copy <cr><nl> line ends", "false");
        optCopySelect = new TerminalOption("copy-select", "Copy on select", "true");
        optEncoding = new TerminalOption("encoding", "Character encoding to use", "iso-8859-1");
        optFontName = new TerminalOption("font-name", "", TerminalDefProps.defaultFont());
        optFontSize = new TerminalOption("font-size", "", "12");
        optGeometry = new TerminalOption("geometry", "", "80x24");
        optTermType = new TerminalOption("term-type", "", "xterm");
        optSaveLines = new TerminalOption("save-lines", "", "512");
        optScrollBar = new TerminalOption("scrollbar", "", "right");
        optBgColor = new TerminalOption("bg-color", "", "white");
        optFgColor = new TerminalOption("fg-color", "", "black");
        optCursorColor = new TerminalOption("cursor-color", "", "i_blue");
        optSelectDelim = new TerminalOption("select-delim", "", "\" \"");
        optPaseButton = new TerminalOption("paste-button", "", "middle");
        optInputCharset = new TerminalOption("input-charset", "", "none");
        optLineSpaceDelta = new TerminalOption("line-space-delta", "", "0");
        optKeyKludge = new TerminalOption("key-kludge", "Workaround for MS JVM", "false");
        optionsDef = new TerminalOption[]{optPassthruPrint, optCopyCrNl, optCopySelect};
        settingsDef = new TerminalOption[]{optEncoding, optFontName, optFontSize, optTermType, optSaveLines, optGeometry, optScrollBar, optBgColor, optFgColor, optCursorColor, optSelectDelim, optPaseButton, optInputCharset, optLineSpaceDelta};
        obsoleteOptions = new String[]{"resize-gravity", "80x132-enable", "80x132-toggle"};
        byte[] byArray = new byte[1];
        for (n = 0; n < 256; ++n) {
            byArray[0] = (byte)n;
            char[] cArray = new String(byArray).toCharArray();
            TerminalWin.byte2char[n] = cArray.length > 0 ? cArray[0] : (char)n;
        }
        String[] stringArray = new String[]{"com.mindbright.terminal.TerminalVT100Style", "com.mindbright.terminal.tandem6530.Terminal6530"};
        terminalList = new Class[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            try {
                TerminalWin.terminalList[n] = Class.forName(stringArray[n]);
                continue;
            }
            catch (Exception exception) {
                TerminalWin.terminalList[n] = null;
            }
        }
        defaultProperties = new Properties();
        TerminalOption[] terminalOptionArray = settingsDef;
        for (n = 0; n < terminalOptionArray.length; ++n) {
            ((Hashtable)defaultProperties).put(terminalOptionArray[n].getKey(), terminalOptionArray[n].getDefault());
        }
        terminalOptionArray = optionsDef;
        for (n = 0; n < terminalOptionArray.length; ++n) {
            ((Hashtable)defaultProperties).put(terminalOptionArray[n].getKey(), terminalOptionArray[n].getDefault());
        }
        terminalOptionArray = TerminalWin.getTerminalsOptions();
        for (n = 0; n < terminalOptionArray.length; ++n) {
            ((Hashtable)defaultProperties).put(terminalOptionArray[n].getKey(), terminalOptionArray[n].getDefault());
        }
        propertyNames = new String[((Hashtable)defaultProperties).size()];
        Enumeration<?> enumeration = defaultProperties.propertyNames();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TerminalWin.propertyNames[n2++] = string;
        }
        OPT_PASSTHRU_PRN = 0;
        OPT_COPY_SEL = 1;
        OPT_KEY_KLUDGE = 2;
        OPT_LAST_OPT = 3;
    }
}

