/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.GUI;
import java.util.Hashtable;

public abstract class TerminalDefProps {
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static Hashtable oldPropNames = new Hashtable();
    public static String[] systemFonts;

    public static String backwardCompatProp(String string) {
        String string2 = (String)oldPropNames.get(string);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public static String fontList() {
        if (systemFonts == null) {
            systemFonts = GUI.getFontList();
        }
        String string = "";
        for (int i = 0; i < systemFonts.length; ++i) {
            string = string + systemFonts[i];
            if (i >= systemFonts.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public static String defaultFont() {
        if (TerminalDefProps.fontExists("monospaced")) {
            return "Monospaced";
        }
        if (TerminalDefProps.fontExists("courier")) {
            return "Courier";
        }
        if (TerminalDefProps.fontExists("dialoginput")) {
            return "DialogInput";
        }
        return systemFonts[0];
    }

    public static boolean fontExists(String string) {
        try {
            int n;
            if (systemFonts == null) {
                systemFonts = GUI.getFontList();
            }
            for (n = 0; n < systemFonts.length && !systemFonts[n].equalsIgnoreCase(string); ++n) {
            }
            if (n == systemFonts.length) {
                return false;
            }
        }
        catch (Error error) {
            return true;
        }
        return true;
    }

    static {
        oldPropNames.put("rv", "rev-video");
        oldPropNames.put("aw", "autowrap");
        oldPropNames.put("rw", "rev-autowrap");
        oldPropNames.put("im", "insert-mode");
        oldPropNames.put("al", "auto-linefeed");
        oldPropNames.put("sk", "repos-input");
        oldPropNames.put("si", "repos-output");
        oldPropNames.put("vi", "visible-cursor");
        oldPropNames.put("le", "local-echo");
        oldPropNames.put("vb", "visual-bell");
        oldPropNames.put("ct", "map-ctrl-space");
        oldPropNames.put("dc", "80x132-toggle");
        oldPropNames.put("da", "80x132-enable");
        oldPropNames.put("lp", "local-pgkeys");
        oldPropNames.put("sc", "copy-crnl");
        oldPropNames.put("ad", "ascii-line");
        oldPropNames.put("cs", "copy-select");
        oldPropNames.put("fn", "font-name");
        oldPropNames.put("fs", "font-size");
        oldPropNames.put("gm", "geometry");
        oldPropNames.put("te", "term-type");
        oldPropNames.put("sl", "save-lines");
        oldPropNames.put("sb", "scrollbar");
        oldPropNames.put("bg", "bg-color");
        oldPropNames.put("fg", "fg-color");
        oldPropNames.put("cc", "cursor-color");
        oldPropNames.put("bs", "backspace-send");
        oldPropNames.put("de", "delete-send");
        oldPropNames.put("sd", "select-delim");
        oldPropNames.put("pb", "paste-button");
    }
}

