/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;

public class Screen {
    protected static final boolean DEBUG = false;
    public static final int GRAVITY_SOUTHWEST = 0;
    public static final int GRAVITY_NORTHWEST = 1;
    public static final int MIN_ROWS = 2;
    public static final int MIN_COLS = 8;
    public static final int MAX_COLS = 512;
    public static final int MAX_ROWS = 512;
    public static final int MAX_SAVED_LINES = 8192;
    protected int rows;
    protected int cols;
    protected int windowTop;
    protected int windowBottom;
    protected int windowLeft;
    protected int windowRight;
    protected boolean complexScroll;
    protected int curRow = 0;
    protected int curCol = 0;
    protected int lastCursorRow;
    protected int lastCursorCol;
    protected int selectTopRow;
    protected int selectTopCol;
    protected int selectBottomRow;
    protected int selectBottomCol;
    protected boolean hasSelection;
    protected int selectClickRow = -1;
    protected boolean selectClickState;
    protected int curAttr = 32768;
    protected boolean autoLF;
    protected boolean autoWrap;
    protected boolean autoReverseWrap;
    protected boolean insertMode;
    protected int curRowSave;
    protected int curColSave;
    protected int curAttrSave;
    protected char[][] screen;
    protected int[][] attributes;
    protected boolean[] autowraps;
    protected char defaultChar;
    protected char[] defaultChars;
    protected int defaultAttrib;
    protected int[] defaultAttribs;
    protected int saveLines;
    protected int visTop = 0;
    protected static final char[] spacerow = new char[512];
    protected static final int[] zerorow = new int[512];
    protected boolean[] tabStops = new boolean[512];
    protected boolean[] termOptions;
    protected DisplayView display = null;
    private static int ATTR_MASK;

    public Screen(int n, int n2) {
        this(n, n2, '\u0000', 0);
    }

    public Screen(int n, int n2, char c, int n3) {
        this.defaultChar = c;
        this.defaultAttrib = n3;
        this.defaultChars = new char[512];
        this.defaultAttribs = new int[512];
        for (int i = 0; i < 512; ++i) {
            this.defaultChars[i] = this.defaultChar;
            this.defaultAttribs[i] = n3;
        }
        this.resizeBuffers(n, n2);
        this.resetWindow();
        this.resetTabs();
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
    }

    protected void updateDirtyArea(int n, int n2, int n3, int n4) {
        if (this.display != null) {
            this.display.updateDirtyArea(this.visTop + n, n2, this.visTop + n3, n4);
        }
    }

    protected void setCursorPosition(int n, int n2) {
        if (this.display != null) {
            this.display.setCursorPosition(this.visTop + n, n2);
        }
    }

    public int getSaveLines() {
        return this.saveLines;
    }

    public synchronized boolean setSaveLines(int n) {
        boolean bl = false;
        int n2 = this.saveLines;
        boolean bl2 = false;
        n = n < 0 ? 0 : n;
        int n3 = n = n > 8192 ? 8192 : n;
        if (this.saveLines != n) {
            int n4;
            int n5;
            char[][] cArray = this.screen;
            int[][] nArray = this.attributes;
            boolean[] blArray = this.autowraps;
            this.saveLines = n;
            try {
                this.resizeBuffers(this.rows, this.cols);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.saveLines = n2;
                this.resizeBuffers(this.rows, this.cols);
                bl2 = true;
            }
            int n6 = 0;
            if (n2 < this.saveLines) {
                n5 = 0;
                n4 = n2 + this.rows;
            } else if (this.visTop <= this.saveLines) {
                n5 = 0;
                n4 = this.visTop + this.rows;
            } else {
                n5 = this.visTop - this.saveLines;
                n4 = this.saveLines + this.rows;
                this.visTop -= n5;
                bl = true;
            }
            System.arraycopy(cArray, n5, this.screen, n6, n4);
            System.arraycopy(nArray, n5, this.attributes, n6, n4);
            System.arraycopy(blArray, n5, this.autowraps, n6, n4);
        }
        if (bl && this.display != null) {
            this.display.setVisTop(this.visTop);
        }
        return !bl2;
    }

    public synchronized void clearSaveLines() {
        char[][] cArray = this.screen;
        int[][] nArray = this.attributes;
        boolean[] blArray = this.autowraps;
        this.resizeBuffers(this.rows, this.cols);
        System.arraycopy(cArray, this.visTop, this.screen, 0, this.rows);
        System.arraycopy(nArray, this.visTop, this.attributes, 0, this.rows);
        System.arraycopy(blArray, this.visTop, this.autowraps, 0, this.rows);
        this.visTop = 0;
        if (this.display != null) {
            this.display.setVisTop(this.visTop);
            this.setCursorPosition(this.curRow, this.curCol);
        }
    }

    protected char[] makeCharLine() {
        char[] cArray = new char[this.cols];
        System.arraycopy(this.defaultChars, 0, cArray, 0, this.cols);
        return cArray;
    }

    protected int[] makeAttribLine() {
        int[] nArray = new int[this.cols];
        System.arraycopy(this.defaultAttribs, 0, nArray, 0, this.cols);
        return nArray;
    }

    public synchronized void resizeBuffers(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        int n3 = n + this.saveLines;
        this.screen = new char[n3][];
        this.attributes = new int[n3][];
        this.autowraps = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            this.screen[i] = this.makeCharLine();
            this.attributes[i] = this.makeAttribLine();
        }
    }

    public void writeLineDrawChar(char c) {
        this.writeChar(c, this.curAttr | 0x100, false);
    }

    public void writeChar(char c) {
        this.writeChar(c, this.curAttr, this.insertMode);
    }

    public void writeChar(char c, int n) {
        this.writeChar(c, n, this.insertMode);
    }

    public synchronized void writeChar(char c, int n, boolean bl) {
        boolean bl2 = false;
        int n2 = 1;
        if (c > '\u00ff' && this.display.isWide(c)) {
            bl2 = true;
            n2 = 2;
        }
        this.checkWrap();
        if (bl) {
            this.insertChars(n2);
        }
        int n3 = this.visTop + this.curRow;
        this.attributes[n3][this.curCol] = n;
        this.screen[n3][this.curCol++] = c;
        if (bl2) {
            int[] nArray = this.attributes[n3];
            int n4 = this.curCol - 1;
            nArray[n4] = nArray[n4] | 0x200;
            if (this.attributes[n3].length > this.curCol) {
                this.attributes[n3][this.curCol++] = 1024;
            }
        }
        this.setCursorPosition(this.curRow, this.curCol);
        this.updateDirtyArea(this.curRow, this.curCol - n2, this.curRow + 1, this.curCol);
    }

    public int getCursorRow() {
        return this.curRow;
    }

    public int getCursorCol() {
        return this.curCol;
    }

    public int getScreenTop() {
        return this.visTop;
    }

    public int getTotalLines() {
        return this.visTop + this.rows;
    }

    public char[] getCharsAt(int n) {
        return this.getCharsAt(n, false);
    }

    public synchronized char[] getCharsAt(int n, boolean bl) {
        if (bl) {
            n += this.visTop;
        }
        if (n < 0 || n >= this.rows + this.saveLines) {
            return null;
        }
        return this.screen[n];
    }

    public int[] getAttribsAt(int n) {
        return this.getAttribsAt(n, false);
    }

    public synchronized int[] getAttribsAt(int n, boolean bl) {
        if (bl) {
            n += this.visTop;
        }
        if (n < 0 || n >= this.rows + this.saveLines) {
            System.out.println("Screen: row is " + n + " max=" + (this.rows + this.saveLines));
            return null;
        }
        return this.attributes[n];
    }

    public void setAutoLF(boolean bl) {
        this.autoLF = bl;
    }

    public void setAutoWrap(boolean bl) {
        this.autoWrap = bl;
    }

    public void setAutoReverseWrap(boolean bl) {
        this.autoReverseWrap = bl;
    }

    public void setInsertMode(boolean bl) {
        this.insertMode = bl;
    }

    public int getVisTop() {
        return this.visTop;
    }

    public int getCurRow() {
        return this.curRow;
    }

    public int getCurCol() {
        return this.curCol;
    }

    public int getSelectTopRow() {
        return this.selectTopRow;
    }

    public int getSelectTopCol() {
        return this.selectTopCol;
    }

    public int getSelectBottomRow() {
        return this.selectBottomRow;
    }

    public int getSelectBottomCol() {
        return this.selectBottomCol;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    protected void checkWrap() {
        if (this.curCol == this.cols) {
            if (this.autoWrap) {
                this.autowraps[this.visTop + this.curRow] = true;
                ++this.curRow;
                this.curCol = 0;
                if (this.curRow == this.windowBottom) {
                    this.scrollUp(1);
                    this.curRow = this.windowBottom - 1;
                }
            } else {
                --this.curCol;
            }
        }
    }

    public void fillScreen(char c) {
        int n;
        int[] nArray = this.makeAttribLine();
        char[] cArray = new char[this.cols];
        for (n = 0; n < this.cols; ++n) {
            nArray[n] = this.curAttr;
            cArray[n] = c;
        }
        for (n = this.windowTop; n < this.windowBottom; ++n) {
            this.screen[this.visTop + n] = new char[this.cols];
            this.attributes[this.visTop + n] = this.makeAttribLine();
            this.autowraps[this.visTop + n] = false;
            System.arraycopy(cArray, 0, this.screen[this.visTop + n], 0, this.cols);
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
        }
        if (this.isIntersectingSelect(0, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(0, 0, this.rows, this.cols);
    }

    public void doBS() {
        this.cursorBackward(1);
    }

    public void doTab() {
        if (this.curCol < this.windowRight) {
            int n;
            for (n = this.curCol + 1; n < this.windowRight && !this.tabStops[n]; ++n) {
            }
            this.curCol = n < this.windowRight ? n : this.windowRight - 1;
            this.setCursorPosition(this.curRow, this.curCol);
        }
    }

    public void doTabs(int n) {
        while (n-- > 0) {
            this.doTab();
        }
    }

    public void doBackTabs(int n) {
        if (this.curCol > 0 && n >= 0) {
            int n2;
            for (n2 = this.curCol - 1; !(n2 < 0 || this.tabStops[n2] && --n == 0); --n2) {
            }
            this.curCol = n2 < 0 ? 0 : n2;
            this.setCursorPosition(this.curRow, this.curCol);
        }
    }

    public void setTab(int n) {
        this.tabStops[n] = true;
    }

    public void clearTab(int n) {
        this.tabStops[n] = false;
    }

    public void resetTabs() {
        for (int i = 0; i < 512; ++i) {
            this.tabStops[i] = i % 8 == 0;
        }
    }

    public void clearAllTabs() {
        for (int i = 0; i < 512; ++i) {
            this.tabStops[i] = false;
        }
    }

    public void doCR() {
        this.curCol = this.windowLeft;
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void doLF() {
        ++this.curRow;
        if (this.curRow == this.windowBottom) {
            this.scrollUp(1);
            this.curRow = this.windowBottom - 1;
        }
        this.setCursorPosition(this.curRow, this.curCol);
        if (this.autoLF) {
            this.doCR();
        }
    }

    public void resetWindow() {
        this.windowTop = 0;
        this.windowBottom = this.rows;
        this.windowLeft = 0;
        this.windowRight = this.cols;
        this.complexScroll = false;
    }

    public void setWindow(int n, int n2) {
        this.setWindow(n, 0, n2, this.cols);
    }

    public void setWindow(int n, int n2, int n3, int n4) {
        this.windowTop = n;
        this.windowLeft = n2;
        this.windowBottom = n3;
        this.windowRight = n4;
        if (this.hasSelection) {
            int n5 = this.selectTopRow - this.visTop;
            int n6 = this.selectBottomRow - this.visTop;
            if (n != 0 && (n5 >= 0 || n6 >= 0)) {
                if (!(n5 < n && n6 < n || n5 >= n3 && n6 >= n3)) {
                    this.resetSelection();
                }
            } else if (n5 >= n3 || n6 >= n3) {
                this.resetSelection();
            }
        }
        this.complexScroll = this.windowLeft != 0 || this.windowRight != this.cols;
    }

    public int getWindowTop() {
        return this.windowTop;
    }

    public int getWindowBottom() {
        return this.windowBottom;
    }

    public int getWindowLeft() {
        return this.windowLeft;
    }

    public int getWindowRight() {
        return this.windowRight;
    }

    public int getCursorV() {
        return this.curRow;
    }

    public int getCursorH() {
        return this.curCol;
    }

    public void cursorSetPos(int n, int n2, boolean bl) {
        int n3 = this.rows - 1;
        int n4 = this.cols - 1;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n += this.windowTop;
            n3 = this.windowBottom - 1;
            n5 = this.windowTop;
            n2 += this.windowLeft;
            n4 = this.windowRight - 1;
            n6 = this.windowLeft;
        }
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        this.curRow = n;
        this.curCol = n2;
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void cursorUp(int n) {
        int n2 = this.curRow < this.windowTop ? 0 : this.windowTop;
        this.curRow -= n;
        if (this.curRow < n2) {
            this.curRow = n2;
        }
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void cursorDown(int n) {
        int n2 = this.curRow > this.windowBottom - 1 ? this.rows - 1 : this.windowBottom - 1;
        this.curRow += n;
        if (this.curRow > n2) {
            this.curRow = n2;
        }
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void cursorForward(int n) {
        this.curCol += n;
        if (this.curCol > this.windowRight) {
            this.curCol = this.windowRight;
        }
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void cursorBackward(int n) {
        do {
            --this.curCol;
            if (this.curCol >= this.windowLeft) continue;
            if (this.autoReverseWrap) {
                this.curCol = this.windowRight - (this.windowLeft - this.curCol);
                this.cursorUp(1);
                continue;
            }
            this.curCol = this.windowLeft;
        } while (--n > 0);
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public void cursorIndex(int n) {
        if (this.curRow > this.windowBottom || this.curRow + n < this.windowBottom) {
            this.cursorDown(n);
        } else {
            int n2 = this.windowBottom - this.curRow;
            this.cursorDown(n2);
            this.scrollUp(n - n2 + 1);
        }
    }

    public void cursorIndexRev(int n) {
        if (this.curRow < this.windowTop || this.curRow - n >= this.windowTop) {
            this.cursorUp(n);
        } else {
            int n2 = this.curRow - this.windowTop;
            this.scrollDown(n - n2);
            this.cursorUp(n2);
        }
    }

    public void cursorSave() {
        this.curRowSave = this.curRow;
        this.curColSave = this.curCol;
        this.curAttrSave = this.curAttr;
    }

    public void cursorRestore() {
        this.curRow = this.curRowSave;
        this.curCol = this.curColSave;
        this.curAttr = this.curAttrSave;
        this.setCursorPosition(this.curRow, this.curCol);
    }

    public synchronized void scrollUp(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowTop;
        boolean bl = false;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = n2 - n + this.windowTop;
                for (n4 = this.windowTop; n4 < n3; ++n4) {
                    System.arraycopy(this.screen[this.visTop + n4 + n], this.windowLeft, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n4 + n], this.windowLeft, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                }
            }
            for (n4 = n3; n4 < this.windowBottom; ++n4) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
            }
        } else if (this.windowTop == 0 && this.windowBottom == this.rows && this.saveLines > 0) {
            int n5;
            int n6 = n5 = n < n2 ? n : n2;
            if (this.visTop + n5 > this.saveLines) {
                if (this.hasSelection) {
                    if (this.selectTopRow - n < 0) {
                        this.resetSelection();
                    } else {
                        this.scrollSelection(-n);
                    }
                }
                int n7 = n2 - n5;
                System.arraycopy(this.screen, n5, this.screen, 0, this.saveLines + n7);
                System.arraycopy(this.attributes, n5, this.attributes, 0, this.saveLines + n7);
                System.arraycopy(this.autowraps, n5, this.autowraps, 0, this.saveLines + n7);
                for (int i = n2 - n5; i < n2; ++i) {
                    this.screen[this.saveLines + i] = this.makeCharLine();
                    this.attributes[this.saveLines + i] = this.makeAttribLine();
                    this.autowraps[this.saveLines + i] = false;
                }
            } else {
                this.visTop += n5;
                bl = true;
            }
        } else {
            if (n < n2) {
                int n8 = this.visTop + this.windowTop + n;
                int n9 = this.visTop + this.windowTop;
                int n10 = n2 - n;
                n3 = n2 - n + this.windowTop;
                System.arraycopy(this.screen, n8, this.screen, n9, n10);
                System.arraycopy(this.attributes, n8, this.attributes, n9, n10);
                System.arraycopy(this.autowraps, n8, this.autowraps, n9, n10);
            }
            for (int i = n3; i < this.windowBottom; ++i) {
                this.screen[this.visTop + i] = this.makeCharLine();
                this.attributes[this.visTop + i] = this.makeAttribLine();
                this.autowraps[this.visTop + i] = false;
            }
        }
        if (bl && this.display != null) {
            this.display.setVisTop(this.visTop);
        }
        this.setCursorPosition(this.curRow, this.curCol);
        this.updateDirtyArea(this.windowTop, this.windowLeft, this.windowBottom, this.windowRight);
    }

    public synchronized void scrollDown(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowBottom;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = this.windowTop + n;
                for (n4 = this.windowBottom - 1; n4 >= n3; --n4) {
                    System.arraycopy(this.screen[this.visTop + n4 - n], this.windowLeft, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n4 - n], this.windowLeft, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                }
            }
            for (n4 = this.windowTop; n4 < n3; ++n4) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
            }
        } else {
            if (n < n2) {
                n3 = this.windowTop + n;
                int n5 = this.visTop + this.windowTop;
                int n6 = this.visTop + this.windowTop + n;
                int n7 = n2 - n;
                System.arraycopy(this.screen, n5, this.screen, n6, n7);
                System.arraycopy(this.attributes, n5, this.attributes, n6, n7);
                System.arraycopy(this.autowraps, n5, this.autowraps, n6, n7);
            }
            for (int i = this.windowTop; i < n3; ++i) {
                this.screen[this.visTop + i] = this.makeCharLine();
                this.attributes[this.visTop + i] = this.makeAttribLine();
                this.autowraps[this.visTop + i] = false;
            }
        }
        this.setCursorPosition(this.curRow, this.curCol);
        this.updateDirtyArea(this.windowTop, 0, this.windowBottom, this.cols);
    }

    public synchronized void clearBelow() {
        int n;
        this.clearRight();
        int[] nArray = this.makeAttribLine();
        for (n = 0; n < this.cols; ++n) {
            nArray[n] = this.curAttr & ATTR_MASK;
        }
        for (n = this.curRow + 1; n < this.windowBottom; ++n) {
            this.screen[this.visTop + n] = this.makeCharLine();
            this.attributes[this.visTop + n] = this.makeAttribLine();
            this.autowraps[this.visTop + n] = false;
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
        }
        if (this.isIntersectingSelect(this.curRow, 0, this.windowBottom, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public synchronized void clearAbove() {
        int n;
        this.clearLeft();
        int[] nArray = this.makeAttribLine();
        for (n = 0; n < this.cols; ++n) {
            nArray[n] = this.curAttr & ATTR_MASK;
        }
        for (n = this.windowTop; n < this.curRow; ++n) {
            this.screen[this.visTop + n] = this.makeCharLine();
            this.attributes[this.visTop + n] = this.makeAttribLine();
            this.autowraps[this.visTop + n] = false;
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
        }
        if (this.isIntersectingSelect(this.windowTop, 0, this.curRow, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.windowTop, 0, this.curRow, this.cols);
    }

    public synchronized void clearScreen() {
        int n;
        int[] nArray = this.makeAttribLine();
        for (n = 0; n < this.cols; ++n) {
            nArray[n] = this.curAttr & ATTR_MASK;
        }
        for (n = this.windowTop; n < this.windowBottom; ++n) {
            this.screen[this.visTop + n] = this.makeCharLine();
            this.attributes[this.visTop + n] = this.makeAttribLine();
            this.autowraps[this.visTop + n] = false;
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
        }
        if (this.isIntersectingSelect(0, 0, this.rows, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(0, 0, this.rows, this.cols);
    }

    public synchronized void clearRight() {
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, this.cols - this.curCol);
        for (int i = this.curCol; i < this.cols; ++i) {
            this.attributes[this.visTop + this.curRow][i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, this.curCol, this.curRow + 1, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.cols);
    }

    public synchronized void clearLeft() {
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], 0, this.curCol);
        for (int i = 0; i <= this.curCol; ++i) {
            this.attributes[this.visTop + this.curRow][i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, 0, this.curRow + 1, this.curCol)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.curCol);
    }

    public synchronized void clearLine() {
        this.screen[this.visTop + this.curRow] = this.makeCharLine();
        this.attributes[this.visTop + this.curRow] = this.makeAttribLine();
        this.autowraps[this.visTop + this.curRow] = false;
        for (int i = 0; i < this.cols; ++i) {
            this.attributes[this.visTop + this.curRow][i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, 0, this.curRow + 1, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.cols);
    }

    public synchronized void eraseChars(int n) {
        if (n > this.cols - this.curCol) {
            n = this.cols - this.curCol;
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, n);
        for (int i = 0; i < n; ++i) {
            this.attributes[this.visTop + this.curRow][this.curCol + i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, this.curCol, this.curRow, this.curCol + n)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow, this.curCol + n);
    }

    public synchronized void insertChars(int n) {
        int n2 = this.windowRight;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.curCol + n;
            System.arraycopy(this.screen[this.visTop + this.curRow], this.curCol, this.screen[this.visTop + this.curRow], n2, this.windowRight - n2);
            System.arraycopy(this.attributes[this.visTop + this.curRow], this.curCol, this.attributes[this.visTop + this.curRow], n2, this.windowRight - n2);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
        for (int i = this.curCol; i < n2; ++i) {
            this.attributes[this.visTop + this.curRow][i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, this.curCol, this.curRow + 1, this.windowRight)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public synchronized void deleteChars(int n) {
        int n2 = this.curCol;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.windowRight - n;
            System.arraycopy(this.screen[this.visTop + this.curRow], this.curCol + n, this.screen[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
            System.arraycopy(this.attributes[this.visTop + this.curRow], this.curCol + n, this.attributes[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], n2, this.windowRight - n2);
        for (int i = n2; i < this.windowRight; ++i) {
            this.attributes[this.visTop + this.curRow][i] = this.curAttr & ATTR_MASK;
        }
        if (this.isIntersectingSelect(this.curRow, this.curCol, this.curRow + 1, this.windowRight)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public synchronized void insertLines(int n) {
        int n2 = this.windowBottom;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                for (n3 = this.windowBottom - 1; n3 >= n2; --n3) {
                    System.arraycopy(this.screen[this.visTop + n3 - n], this.windowLeft, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n3 - n], this.windowLeft, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                }
            }
            for (n3 = this.curRow; n3 < n2; ++n3) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
            }
        } else {
            int n4;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                System.arraycopy(this.screen, this.visTop + this.curRow, this.screen, this.visTop + n2, this.windowBottom - n2);
                System.arraycopy(this.attributes, this.visTop + this.curRow, this.attributes, this.visTop + n2, this.windowBottom - n2);
                System.arraycopy(this.autowraps, this.visTop + this.curRow, this.autowraps, this.visTop + n2, this.windowBottom - n2);
            }
            int[] nArray = this.makeAttribLine();
            for (n4 = 0; n4 < this.cols; ++n4) {
                nArray[n4] = this.curAttr & ATTR_MASK;
            }
            for (n4 = this.curRow; n4 < n2; ++n4) {
                this.screen[this.visTop + n4] = this.makeCharLine();
                this.attributes[this.visTop + n4] = this.makeAttribLine();
                this.autowraps[this.visTop + n4] = false;
                System.arraycopy(nArray, 0, this.attributes[this.visTop + n4], 0, this.cols);
            }
        }
        if (this.isIntersectingSelect(this.curRow, 0, this.windowBottom, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public synchronized void deleteLines(int n) {
        int n2 = this.curRow;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n - 1;
                for (n3 = this.curRow; n3 <= n2; ++n3) {
                    System.arraycopy(this.screen[this.visTop + n3 + n], this.windowLeft, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n3 + n], this.windowLeft, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                }
            }
            for (n3 = n2; n3 < this.windowBottom; ++n3) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
            }
        } else {
            int n4;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n;
                System.arraycopy(this.screen, this.visTop + this.curRow + n, this.screen, this.visTop + this.curRow, n2 - this.curRow);
                System.arraycopy(this.attributes, this.visTop + this.curRow + n, this.attributes, this.visTop + this.curRow, n2 - this.curRow);
                System.arraycopy(this.autowraps, this.visTop + this.curRow + n, this.autowraps, this.visTop + this.curRow, n2 - this.curRow);
            }
            int[] nArray = this.makeAttribLine();
            for (n4 = 0; n4 < this.cols; ++n4) {
                nArray[n4] = this.curAttr & ATTR_MASK;
            }
            for (n4 = n2; n4 < this.windowBottom; ++n4) {
                this.screen[this.visTop + n4] = this.makeCharLine();
                this.attributes[this.visTop + n4] = this.makeAttribLine();
                this.autowraps[this.visTop + n4] = false;
                System.arraycopy(nArray, 0, this.attributes[this.visTop + n4], 0, this.cols);
            }
        }
        if (this.isIntersectingSelect(this.curRow, 0, this.windowBottom, this.cols)) {
            this.resetSelection();
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void setAttribute(int n, boolean bl) {
        this.curAttr = bl ? (this.curAttr |= n) : (this.curAttr &= ~n);
    }

    public boolean getAttribute(int n) {
        return (this.curAttr & n) == n;
    }

    public void setForegroundColor(int n) {
        if (n >= 0 && n < 8) {
            if ((this.curAttr & 1) != 0) {
                n += 8;
            }
            this.curAttr &= 0xFF00FFBF;
            this.curAttr |= 0x40 | n << 16;
        } else {
            this.curAttr &= 0xFFFFFFBF;
        }
    }

    public void setBackgroundColor(int n) {
        if (n >= 0 && n < 8) {
            this.curAttr &= 0xFFFF7F;
            this.curAttr |= 0x80 | n << 24;
        } else {
            this.curAttr &= 0xFFFFFF7F;
        }
    }

    public void clearAllAttributes() {
        this.curAttr = 32768;
    }

    public synchronized void resize(int n, int n2) {
        int n3 = this.cols;
        int n4 = this.rows;
        char[][] cArray = this.screen;
        int[][] nArray = this.attributes;
        boolean[] blArray = this.autowraps;
        boolean bl = false;
        if (n2 != n3) {
            this.resetSelection();
        }
        if (n != this.rows || n2 != this.cols) {
            int n5;
            this.resizeBuffers(n, n2);
            this.resetWindow();
            this.clearScreen();
            n3 = n3 < n2 ? n3 : n2;
            int n6 = 0;
            int n7 = this.visTop + this.curRow + 1;
            if (n7 > this.saveLines + n) {
                n6 = n7 - (this.saveLines + n);
                n7 -= n6;
            }
            for (n5 = 0; n5 < n7; ++n5) {
                System.arraycopy(cArray[n5 + n6], 0, this.screen[n5], 0, n3);
                System.arraycopy(nArray[n5 + n6], 0, this.attributes[n5], 0, n3);
                this.autowraps[n5] = blArray[n5 + n6];
            }
            n5 = n4 - 1 - this.curRow;
            int n8 = n4 - (n + n6);
            if (n4 > n && n5 >= -1 * n8) {
                n8 -= n5;
            }
            if (this.visTop + n8 < 0) {
                n8 = -1 * this.visTop;
            }
            if (n8 != 0) {
                this.visTop += n8;
                bl = true;
                this.curRow -= n8;
            }
            if (this.curRow >= n) {
                this.curRow = n - 1;
            }
            if (this.curCol >= n2) {
                this.curCol = n2 - 1;
            }
        }
        if (bl && this.display != null) {
            this.display.setPendingVisTopChange(this.visTop);
        }
        this.setCursorPosition(this.curRow, this.curCol);
    }

    protected synchronized int nextPrintedChar(int n, int n2) {
        int n3;
        for (n3 = n2; n3 < this.cols && this.screen[n][n3] == this.defaultChar; ++n3) {
        }
        return n3;
    }

    protected synchronized int prevPrintedChar(int n, int n2) {
        int n3;
        for (n3 = n2; n3 >= 0 && this.screen[n][n3] == this.defaultChar; --n3) {
        }
        return n3;
    }

    protected String addSpaces(int n, int n2) {
        int n3 = n2 - n;
        if (n2 == this.cols) {
            return "";
        }
        char[] cArray = new char[n3];
        System.arraycopy(spacerow, 0, cArray, 0, n3);
        return new String(cArray);
    }

    protected boolean isIntersectingSelect(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.hasSelection) {
            return false;
        }
        n += this.visTop;
        n3 += this.visTop;
        if (this.selectTopCol < this.selectBottomCol) {
            n8 = this.selectTopCol;
            n7 = this.selectBottomCol;
        } else {
            n8 = this.selectBottomCol;
            n7 = this.selectTopCol;
        }
        if (n2 < n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        if (this.selectTopRow > n3) {
            return false;
        }
        if (this.selectBottomRow < n) {
            return false;
        }
        if (n8 > n5) {
            return false;
        }
        return n7 >= n6;
    }

    public void resetSelection() {
        this.hasSelection = false;
        if (this.display != null) {
            this.display.resetSelection();
        }
    }

    public void selectAll() {
        this.setSelection(this.visTop, 0, this.visTop + this.rows - 1, this.cols - 1);
    }

    protected void scrollSelection(int n) {
        if (!this.hasSelection) {
            return;
        }
        int n2 = this.selectTopRow + n;
        int n3 = this.selectBottomRow + n;
        this.setSelection(n2, this.selectTopCol, n3, this.selectBottomCol);
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.selectTopRow = n;
            this.selectTopCol = n2;
            this.selectBottomRow = n3;
            this.selectBottomCol = n4;
        } else if (n == n3) {
            this.selectTopRow = this.selectBottomRow = n;
            if (n2 < n4) {
                this.selectTopCol = n2;
                this.selectBottomCol = n4;
            } else {
                this.selectTopCol = n4;
                this.selectBottomCol = n2;
            }
        } else {
            this.selectTopRow = n3;
            this.selectTopCol = n4;
            this.selectBottomRow = n;
            this.selectBottomCol = n2;
        }
        if ((this.attributes[this.selectTopRow][this.selectTopCol] & 0x400) != 0) {
            --this.selectTopCol;
        }
        if ((this.attributes[this.selectBottomRow][this.selectBottomCol] & 0x200) != 0) {
            ++this.selectBottomCol;
        }
        this.hasSelection = true;
        if (this.display != null) {
            this.display.resetSelection();
            this.display.setSelection(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol);
        }
    }

    public String getSelection(String string) {
        if (!this.hasSelection) {
            return null;
        }
        if (string == null) {
            string = "\r";
        }
        return this.getContents(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol, string);
    }

    protected synchronized String getContents(int n, int n2, int n3, int n4, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n != n3) {
            int n5;
            int n6;
            for (n6 = n2; n6 < this.cols; ++n6) {
                if ((this.attributes[n][n6] & 0x400) != 0) continue;
                if (this.screen[n][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n, n6);
                    stringBuffer.append(this.addSpaces(n6, n5));
                    n6 = n5 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n][n6]);
            }
            if (n6 == this.cols && !this.autowraps[n]) {
                stringBuffer.append(string);
            }
            for (n6 = n + 1; n6 < n3; ++n6) {
                for (int i = 0; i < this.cols; ++i) {
                    if ((this.attributes[n6][i] & 0x400) != 0) continue;
                    if (this.screen[n6][i] == '\u0000') {
                        n5 = this.nextPrintedChar(n6, i);
                        stringBuffer.append(this.addSpaces(i, n5));
                        i = n5 - 1;
                        continue;
                    }
                    stringBuffer.append(this.screen[n6][i]);
                }
                if (this.autowraps[n6]) continue;
                stringBuffer.append(string);
            }
            for (n6 = 0; n6 <= n4; ++n6) {
                if ((this.attributes[n3][n6] & 0x400) != 0) continue;
                if (this.screen[n3][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n3, n6);
                    stringBuffer.append(this.addSpaces(n6, n5));
                    n6 = n5 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n3][n6]);
            }
            if (n6 == this.cols && !this.autowraps[n3]) {
                stringBuffer.append(string);
            }
        } else {
            int n7;
            for (n7 = n2; n7 <= n4; ++n7) {
                if ((this.attributes[n][n7] & 0x400) != 0) continue;
                if (this.screen[n][n7] == '\u0000') {
                    int n8 = this.nextPrintedChar(n, n7);
                    stringBuffer.append(this.addSpaces(n7, n8));
                    n7 = n8 - 1;
                    continue;
                }
                stringBuffer.append(this.screen[n][n7]);
            }
            if (n7 == this.cols) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void resetClickSelect() {
        this.selectClickRow = -1;
        this.selectClickState = false;
    }

    public synchronized void doClickSelect(int n, int n2, String string) {
        int n3;
        int n4;
        if (this.selectClickRow == n && this.selectClickState) {
            n4 = 0;
            n3 = this.cols - 1;
        } else {
            if (this.screen[n][n2] != '\u0000') {
                int n5;
                for (n5 = n2; n5 >= 0 && string.indexOf(this.screen[n][n5]) == -1 && this.screen[n][n5] != '\u0000'; --n5) {
                }
                n4 = n5 + 1;
                for (n5 = n2; n5 < this.cols && string.indexOf(this.screen[n][n5]) == -1 && this.screen[n][n5] != '\u0000'; ++n5) {
                }
                n3 = n5 - 1;
            } else {
                n4 = this.prevPrintedChar(n, n2) + 1;
                n3 = this.nextPrintedChar(n, n2) - 1;
            }
            n4 = n4 > n2 ? n2 : n4;
            n3 = n3 < n2 ? n2 : n3;
        }
        this.selectClickState = !this.selectClickState;
        this.selectClickRow = n;
        this.setSelection(n, n4, n, n3);
    }

    public synchronized SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        int n;
        char c;
        int n2 = string.length();
        int n3 = this.visTop + this.rows;
        boolean bl3 = false;
        int n4 = 0;
        char c2 = c = bl2 ? string.charAt(0) : Character.toLowerCase(string.charAt(0));
        if (bl) {
            block21: {
                int n5;
                int n6;
                if (searchContext != null) {
                    n6 = searchContext.getStartRow();
                    n5 = searchContext.getStartCol() - 1;
                    if (n5 < 0) {
                        --n6;
                    }
                } else {
                    n6 = n3;
                    n5 = this.cols - n2;
                }
                n6 = n6 < 0 ? 0 : n6;
                n6 = n6 > n3 - 1 ? n3 - 1 : n6;
                n5 = n5 < 0 ? 0 : n5;
                n5 = n5 > this.cols - 1 ? this.cols - 1 : n5;
                try {
                    for (n = n6; n >= 0; --n) {
                        for (n4 = n5; n4 >= 0; --n4) {
                            if (this.screen[n][n4] == '\u0000' || !this.doMatch(string, c, this.screen[n], n4, bl2, n2)) {
                                continue;
                            }
                            break block21;
                        }
                        n5 = this.cols - 1;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    return null;
                }
            }
            if (n >= 0) {
                bl3 = true;
            }
        } else {
            block22: {
                int n7;
                int n8;
                if (searchContext != null) {
                    n8 = searchContext.getEndRow();
                    n7 = searchContext.getEndCol() + 1;
                    if (n7 >= this.cols) {
                        ++n8;
                    }
                } else {
                    n8 = 0;
                    n7 = 0;
                }
                n8 = n8 < 0 ? 0 : n8;
                n8 = n8 > n3 - 1 ? n3 - 1 : n8;
                n7 = n7 < 0 ? 0 : n7;
                n7 = n7 > this.cols - 1 ? this.cols - 1 : n7;
                try {
                    for (n = n8; n < n3; ++n) {
                        for (n4 = n7; n4 < this.cols - n2; ++n4) {
                            if (this.screen[n][n4] == '\u0000' || !this.doMatch(string, c, this.screen[n], n4, bl2, n2)) {
                                continue;
                            }
                            break block22;
                        }
                        n7 = 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    return null;
                }
            }
            if (n < n3) {
                bl3 = true;
            }
        }
        if (bl3) {
            return new SearchContext(n, n4, n, n4 + n2 - 1);
        }
        return null;
    }

    protected boolean doMatch(String string, char c, char[] cArray, int n, boolean bl, int n2) {
        if (bl) {
            if (cArray[n] != c) {
                return false;
            }
            String string2 = new String(cArray, n, n2);
            if (string2.equals(string)) {
                return true;
            }
        } else {
            if (Character.toLowerCase(cArray[n]) != c) {
                return false;
            }
            String string3 = new String(cArray, n, n2);
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    static {
        for (int i = 0; i < 512; ++i) {
            Screen.spacerow[i] = 32;
            Screen.zerorow[i] = 0;
        }
        ATTR_MASK = -65344;
    }
}

