/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2TransportPDU;

public class SSH2TransportPDUPool
extends SSH2TransportPDU {
    static int POOL_SIZE = 32;
    int inCnt;
    int outCnt;
    int defInSz;
    int defOutSz;
    SSH2TransportPDU[] inPool = new SSH2TransportPDU[POOL_SIZE];
    SSH2TransportPDU[] outPool = new SSH2TransportPDU[POOL_SIZE];

    protected SSH2TransportPDUPool() {
        this.inCnt = POOL_SIZE;
        this.outCnt = POOL_SIZE;
        this.defInSz = SSH2TransportPDU.pktDefaultSize;
        this.defOutSz = SSH2TransportPDU.pktDefaultSize * 3 / 2;
        for (int i = 0; i < POOL_SIZE; ++i) {
            this.inPool[i] = new InPDU(0, this.defInSz);
            this.outPool[i] = new OutPDU(0, this.defOutSz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSH2TransportPDU createInPDU(int n) {
        SSH2TransportPDU[] sSH2TransportPDUArray = this.inPool;
        synchronized (this.inPool) {
            if (this.inCnt == 0 || n > this.defInSz) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new InPDU(0, n);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.inPool[--this.inCnt];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSH2TransportPDU createOutPDU(int n, int n2) {
        SSH2TransportPDU sSH2TransportPDU = null;
        SSH2TransportPDU[] sSH2TransportPDUArray = this.outPool;
        synchronized (this.outPool) {
            if (this.outCnt == 0 || n2 > this.defOutSz) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return new OutPDU(n, n2);
            }
            sSH2TransportPDU = this.outPool[--this.outCnt];
            // ** MonitorExit[var4_4] (shouldn't be in output)
            sSH2TransportPDU.pktType = n;
            return sSH2TransportPDU;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseIn(InPDU inPDU) {
        SSH2TransportPDU[] sSH2TransportPDUArray = this.inPool;
        synchronized (this.inPool) {
            if (this.inCnt < this.inPool.length && inPDU.data.length >= this.defInSz) {
                this.inPool[this.inCnt++] = inPDU;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseOut(OutPDU outPDU) {
        SSH2TransportPDU[] sSH2TransportPDUArray = this.outPool;
        synchronized (this.outPool) {
            if (this.outCnt < this.outPool.length && outPDU.data.length >= this.defOutSz) {
                this.outPool[this.outCnt++] = outPDU;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected class OutPDU
    extends SSH2TransportPDU {
        protected OutPDU(int n, int n2) {
            super(n, n2);
        }

        public void release() {
            this.reset();
            this.pktSize = 0;
            SSH2TransportPDUPool.this.releaseOut(this);
        }
    }

    protected class InPDU
    extends SSH2TransportPDU {
        protected InPDU(int n, int n2) {
            super(n, n2);
        }

        public void release() {
            this.reset();
            this.pktSize = 0;
            SSH2TransportPDUPool.this.releaseIn(this);
        }
    }
}

