/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2Transport;

public abstract class SSH2SimpleSignature
extends SSH2Signature {
    protected String signatureAlgorithm;
    protected String ssh2KeyFormat;
    protected boolean draftIncompatibleSignature;

    protected SSH2SimpleSignature(String string, String string2) {
        this.signatureAlgorithm = string;
        this.ssh2KeyFormat = string2;
    }

    public static SSH2Signature getVerifyInstance(byte[] byArray) throws SSH2Exception {
        String string = SSH2SimpleSignature.getKeyFormat(byArray);
        SSH2Signature sSH2Signature = SSH2Signature.getInstance(string);
        sSH2Signature.initVerify(byArray);
        return sSH2Signature;
    }

    public final String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public byte[] encodeSignature(byte[] byArray) {
        if (this.draftIncompatibleSignature) {
            return byArray;
        }
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length + 4 + this.ssh2KeyFormat.length() + 4);
        sSH2DataBuffer.writeString(this.ssh2KeyFormat);
        sSH2DataBuffer.writeString(byArray);
        return sSH2DataBuffer.readRestRaw();
    }

    public byte[] decodeSignature(byte[] byArray) throws SSH2SignatureException {
        if (this.draftIncompatibleSignature) {
            return byArray;
        }
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length);
        sSH2DataBuffer.writeRaw(byArray);
        int n = sSH2DataBuffer.readInt();
        if (n <= 0 || n > byArray.length) {
            return byArray;
        }
        sSH2DataBuffer.setRPos(sSH2DataBuffer.getRPos() - 4);
        String string = sSH2DataBuffer.readJavaString();
        if (!string.equals(this.ssh2KeyFormat)) {
            throw new SSH2SignatureException(this.ssh2KeyFormat + ", signature blob type " + "mismatch, got '" + string);
        }
        return sSH2DataBuffer.readString();
    }

    public static String getKeyFormat(byte[] byArray) {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length);
        sSH2DataBuffer.writeRaw(byArray);
        return sSH2DataBuffer.readJavaString();
    }

    public void setIncompatibility(SSH2Transport sSH2Transport) {
        this.draftIncompatibleSignature = sSH2Transport.incompatibleSignature;
    }
}

