/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.ssh2.SSH2KeyFingerprint;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportEventAdapter;

public class SSH2HostKeyVerifier
extends SSH2TransportEventAdapter {
    protected String fingerprint;
    protected PublicKey publickey;

    public SSH2HostKeyVerifier(PublicKey publicKey) {
        this.publickey = publicKey;
    }

    public SSH2HostKeyVerifier(String string) {
        this.fingerprint = string;
    }

    public boolean kexAuthenticateHost(SSH2Transport sSH2Transport, SSH2Signature sSH2Signature) {
        boolean bl = false;
        if (this.publickey != null) {
            try {
                bl = SSH2HostKeyVerifier.comparePublicKeys(this.publickey, sSH2Signature.getPublicKey());
            }
            catch (SSH2SignatureException sSH2SignatureException) {
                bl = false;
            }
        } else if (this.fingerprint != null) {
            bl = SSH2HostKeyVerifier.compareFingerprints(this.fingerprint, sSH2Signature);
        }
        return bl;
    }

    public static boolean compareFingerprints(String string, SSH2Signature sSH2Signature) {
        byte[] byArray = null;
        try {
            byArray = sSH2Signature.getPublicKeyBlob();
        }
        catch (SSH2SignatureException sSH2SignatureException) {
            return false;
        }
        String string2 = SSH2KeyFingerprint.md5Hex(byArray);
        String string3 = SSH2KeyFingerprint.bubbleBabble(byArray);
        return string2.equalsIgnoreCase(string) || string3.equalsIgnoreCase(string);
    }

    public static boolean comparePublicKeys(PublicKey publicKey, PublicKey publicKey2) {
        if (publicKey instanceof DSAPublicKey && publicKey2 instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey2;
            if (dSAPublicKey.getY().equals(dSAPublicKey2.getY()) && dSAPublicKey.getParams().getG().equals(dSAPublicKey2.getParams().getG()) && dSAPublicKey.getParams().getP().equals(dSAPublicKey2.getParams().getP()) && dSAPublicKey.getParams().getQ().equals(dSAPublicKey2.getParams().getQ())) {
                return true;
            }
        } else if (publicKey instanceof RSAPublicKey && publicKey2 instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            RSAPublicKey rSAPublicKey2 = (RSAPublicKey)publicKey2;
            if (rSAPublicKey.getPublicExponent().equals(rSAPublicKey2.getPublicExponent()) && rSAPublicKey.getModulus().equals(rSAPublicKey2.getModulus())) {
                return true;
            }
        }
        return false;
    }
}

