/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.net.ftp.FTPException;
import com.mindbright.net.ftp.FTPServer;
import com.mindbright.net.ftp.FTPServerEventHandler;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2SFTP;
import com.mindbright.ssh2.SSH2SFTPClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2FTPOverSFTP
implements FTPServerEventHandler {
    protected SSH2Connection connection;
    protected SSH2SFTPClient sftp;
    protected FTPServer ftp;
    private String remoteDir;
    private String renameFrom;
    private String user;
    private SSH2SFTP.FileAttributes attrs;
    private boolean remoteIsWindows;
    private static int ENDPOINT_UNIX = 0;
    private static int ENDPOINT_WINDOWS = 1;

    protected SSH2FTPOverSFTP(InputStream inputStream, OutputStream outputStream, String string, boolean bl) {
        this.initFTP(inputStream, outputStream, false, string, bl);
    }

    public SSH2FTPOverSFTP(SSH2Connection sSH2Connection, InputStream inputStream, OutputStream outputStream, String string) throws SSH2SFTP.SFTPException {
        this(sSH2Connection, inputStream, outputStream, true, string);
    }

    public SSH2FTPOverSFTP(SSH2Connection sSH2Connection, InputStream inputStream, OutputStream outputStream, boolean bl, String string) throws SSH2SFTP.SFTPException {
        this.initSFTP(sSH2Connection);
        this.initFTP(inputStream, outputStream, bl, string, false);
    }

    protected void initSFTP(SSH2Connection sSH2Connection) throws SSH2SFTP.SFTPException {
        this.connection = sSH2Connection;
        this.attrs = null;
        try {
            this.sftp = new SSH2SFTPClient(sSH2Connection, false);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            if (this.ftp != null) {
                this.ftp.terminate();
            }
            throw sFTPException;
        }
    }

    protected void initFTP(InputStream inputStream, OutputStream outputStream, String string, boolean bl) {
        this.initFTP(inputStream, outputStream, false, string, bl);
    }

    protected void initFTP(InputStream inputStream, OutputStream outputStream, boolean bl, String string, boolean bl2) {
        this.remoteIsWindows = bl;
        this.ftp = new FTPServer(string, this, inputStream, outputStream, bl2);
    }

    public boolean login(String string, String string2) {
        this.connection.getLog().notice("SSH2FTPOverSFTP", "user " + string + " login");
        try {
            this.attrs = this.sftp.realpath(".");
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            return false;
        }
        this.remoteDir = this.attrs.lname;
        this.user = string;
        return true;
    }

    public void quit() {
        this.connection.getLog().notice("SSH2FTPOverSFTP", "user " + this.user + " logout");
        this.sftp.terminate();
    }

    public boolean isPlainFile(String string) {
        try {
            string = this.expandRemote(string);
            this.attrs = this.sftp.lstat(string);
            return this.attrs.isFile();
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            return false;
        }
    }

    public void changeDirectory(String string) throws FTPException {
        if (string != null) {
            String string2 = this.expandRemote(string);
            try {
                this.attrs = this.sftp.realpath(string2);
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                throw new FTPException(550, string + ": No such directory.");
            }
            string2 = this.attrs.lname;
            try {
                SSH2SFTP.FileHandle fileHandle = this.sftp.opendir(string2);
                this.sftp.close(fileHandle);
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                throw new FTPException(550, string + ": Not a directory.");
            }
            this.remoteDir = string2;
        }
    }

    public void renameFrom(String string) throws FTPException {
        try {
            String string2 = this.expandRemote(string);
            this.attrs = this.sftp.lstat(string2);
            this.renameFrom = string2;
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new FTPException(550, string + ": No such file or directory.");
        }
    }

    public void renameTo(String string) throws FTPException {
        if (this.renameFrom != null) {
            try {
                this.sftp.rename(this.renameFrom, this.expandRemote(string));
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                throw new FTPException(550, "rename: Operation failed.");
            }
            finally {
                this.renameFrom = null;
            }
        } else {
            throw new FTPException(503, "Bad sequence of commands.");
        }
    }

    public void delete(String string) throws FTPException {
        try {
            this.sftp.remove(this.expandRemote(string));
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            String string2 = sFTPException instanceof SSH2SFTP.SFTPPermissionDeniedException ? "access denied." : string + ": no such file.";
            throw new FTPException(550, string2);
        }
    }

    public void rmdir(String string) throws FTPException {
        try {
            this.sftp.rmdir(this.expandRemote(string));
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            String string2 = sFTPException instanceof SSH2SFTP.SFTPPermissionDeniedException ? "access denied." : string + ": no such directory.";
            throw new FTPException(550, string2);
        }
    }

    public void mkdir(String string) throws FTPException {
        try {
            this.sftp.mkdir(this.expandRemote(string), new SSH2SFTP.FileAttributes());
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            // empty catch block
        }
    }

    public void chmod(int n, String string) throws FTPException {
        try {
            SSH2SFTP.FileAttributes fileAttributes = new SSH2SFTP.FileAttributes();
            fileAttributes.permissions = n;
            fileAttributes.hasPermissions = true;
            this.sftp.setstat(this.expandRemote(string), fileAttributes);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            // empty catch block
        }
    }

    public String pwd() {
        return this.remoteDir;
    }

    public String system() {
        return "UNIX Type: L8";
    }

    public long modTime(String string) throws FTPException {
        return this.timeAndSize(string)[0];
    }

    public long size(String string) throws FTPException {
        return this.timeAndSize(string)[1];
    }

    private long[] timeAndSize(String string) throws FTPException {
        try {
            long[] lArray = new long[2];
            String string2 = this.expandRemote(string);
            this.attrs = this.sftp.lstat(string2);
            if (!this.attrs.hasSize || !this.attrs.hasModTime) {
                throw new FTPException(550, "SFTP server don't return time/size.");
            }
            lArray[0] = (long)this.attrs.mtime * 1000L;
            lArray[1] = this.attrs.size;
            return lArray;
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new FTPException(550, string + ": No such file or directory.");
        }
    }

    public void store(String string, InputStream inputStream, boolean bl) throws FTPException {
        SSH2SFTP.FileHandle fileHandle = null;
        try {
            string = this.expandRemote(string);
            fileHandle = this.sftp.open(string, 26, new SSH2SFTP.FileAttributes());
            if (!bl) {
                inputStream = new ASCIIFilterIn(inputStream, this.remoteIsWindows ? ENDPOINT_WINDOWS : ENDPOINT_UNIX);
            }
            this.sftp.writeFully(fileHandle, inputStream);
        }
        catch (IOException iOException) {
            throw new FTPException(425, "Error writing to data connection: " + iOException.getMessage());
        }
        catch (SSH2SFTP.SFTPPermissionDeniedException sFTPPermissionDeniedException) {
            throw new FTPException(553, string + ": Permission denied.");
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new FTPException(550, string + ": Error in sftp connection, " + sFTPException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void retrieve(String string, OutputStream outputStream, boolean bl) throws FTPException {
        SSH2SFTP.FileHandle fileHandle = null;
        try {
            String string2 = this.expandRemote(string);
            fileHandle = this.sftp.open(string2, 1, new SSH2SFTP.FileAttributes());
            if (!bl) {
                String string3 = System.getProperty("os.name");
                if (string3 == null) {
                    string3 = "";
                }
                int n = (string3 = string3.toLowerCase()).startsWith("win") ? ENDPOINT_WINDOWS : ENDPOINT_UNIX;
                outputStream = new ASCIIFilterOut(outputStream, n);
            }
            this.sftp.readFully(fileHandle, outputStream);
        }
        catch (SSH2SFTP.SFTPNoSuchFileException sFTPNoSuchFileException) {
            throw new FTPException(550, string + ": No such file or directory.");
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new FTPException(550, string + ": Error in sftp connection, " + sFTPException.getMessage());
        }
        catch (IOException iOException) {
            throw new FTPException(550, string + ": Error in sftp connection, " + iOException.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void list(String string, OutputStream outputStream) throws FTPException {
        try {
            SSH2SFTP.FileAttributes[] fileAttributesArray = this.dirList(string);
            for (int i = 0; i < fileAttributesArray.length; ++i) {
                if (".".equals(fileAttributesArray[i].name) || "..".equals(fileAttributesArray[i].name)) continue;
                String string2 = fileAttributesArray[i].lname;
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string2 = string2 + "\r\n";
                outputStream.write(string2.getBytes());
            }
        }
        catch (IOException iOException) {
            throw new FTPException(425, "Error writing to data connection: " + iOException.getMessage());
        }
    }

    public void nameList(String string, OutputStream outputStream) throws FTPException {
        try {
            SSH2SFTP.FileAttributes[] fileAttributesArray = this.dirList(string);
            for (int i = 0; i < fileAttributesArray.length; ++i) {
                if (".".equals(fileAttributesArray[i].name) || "..".equals(fileAttributesArray[i].name)) continue;
                String string2 = fileAttributesArray[i].name + "\r\n";
                outputStream.write(string2.getBytes());
            }
        }
        catch (IOException iOException) {
            throw new FTPException(425, "Error writing to data connection: " + iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSH2SFTP.FileAttributes[] dirList(String string) throws FTPException {
        SSH2SFTP.FileHandle fileHandle = null;
        SSH2SFTP.FileAttributes[] fileAttributesArray = new SSH2SFTP.FileAttributes[]{};
        try {
            block11: {
                try {
                    String string2 = this.expandRemote(string);
                    this.attrs = this.sftp.lstat(string2);
                    if (this.attrs.isDirectory()) {
                        fileHandle = this.sftp.opendir(string2);
                        fileAttributesArray = this.sftp.readdir(fileHandle);
                        if (fileAttributesArray != null) {
                            for (int i = 0; i < fileAttributesArray.length; ++i) {
                                fileAttributesArray[i].lname = fileAttributesArray[i].toString(fileAttributesArray[i].name);
                            }
                        }
                        break block11;
                    }
                    fileAttributesArray = new SSH2SFTP.FileAttributes[]{new SSH2SFTP.FileAttributes()};
                    fileAttributesArray[0].name = string;
                    fileAttributesArray[0].lname = this.attrs.toString(string);
                }
                catch (SSH2SFTP.SFTPException sFTPException) {
                    throw new FTPException(550, string + ": Not a directory.");
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (fileHandle == null) throw throwable;
                this.sftp.close(fileHandle);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (fileHandle == null) return fileAttributesArray;
        this.sftp.close(fileHandle);
        return fileAttributesArray;
    }

    public void abort() {
    }

    private String expandRemote(String string) {
        if (string == null || string.length() == 0) {
            return this.remoteDir;
        }
        if (string.charAt(0) != '/') {
            string = this.remoteDir + "/" + string;
        }
        return string;
    }

    private class ASCIIFilterOut
    extends OutputStream {
        private int type;
        private OutputStream out;
        private boolean prevcr = false;

        ASCIIFilterOut(OutputStream outputStream, int n) {
            this.out = outputStream;
            this.type = n;
        }

        public void write(int n) throws IOException {
            if (this.type == ENDPOINT_UNIX) {
                if (this.prevcr && n != 10) {
                    this.out.write(13);
                }
                this.prevcr = false;
                if (n == 13) {
                    this.prevcr = true;
                    return;
                }
            } else if (this.type == ENDPOINT_WINDOWS) {
                if (n == 13) {
                    this.prevcr = true;
                } else {
                    if (n == 10 && !this.prevcr) {
                        this.write(13);
                    }
                    this.prevcr = false;
                }
            }
            this.out.write(n);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            if (this.prevcr) {
                this.out.write(13);
            }
            this.out.close();
        }
    }

    private class ASCIIFilterIn
    extends InputStream {
        private int type;
        private int bufch = -1;
        private InputStream in;

        ASCIIFilterIn(InputStream inputStream, int n) {
            this.in = inputStream;
            this.type = n;
        }

        public int read() throws IOException {
            if (this.bufch != -1) {
                int n = this.bufch;
                this.bufch = -1;
                return n;
            }
            int n = this.in.read();
            if (n != -1) {
                if (this.type == ENDPOINT_UNIX) {
                    if (n == 13) {
                        int n2 = this.in.read();
                        if (n2 == 10) {
                            n = n2;
                        } else {
                            this.bufch = n2;
                        }
                    }
                } else if (this.type == ENDPOINT_WINDOWS) {
                    if (n == 13) {
                        this.bufch = this.in.read();
                    } else if (n == 10) {
                        this.bufch = 10;
                        n = 13;
                    }
                }
            }
            return n;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

