/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class SSHTunnelDialogSwing {
    private static final String LBL_CURRENT_TUNNELS = "Current tunnels";
    private static final String LBL_LOCAL = "Local";
    private static final String LBL_REMOTE = "Remote";
    private static final String LBL_LOCALHOST = "localhost";
    private static final String LBL_ALL_HOSTS = "all (0.0.0.0)";
    private static final String LBL_IP = "ip";
    private static final String LBL_TYPE = "Type";
    private static final String LBL_PLUGIN = "Plugin";
    private static final String LBL_SRC_PORT = "Bind port";
    private static final String LBL_BIND_ADDR = "Bind address";
    private static final String LBL_DEST_ADDR = "Dest. address";
    private static final String LBL_DEST_PORT = "Dest. port";
    private static final String LBL_BTN_ADD = "Add...";
    private static final String LBL_BTN_DEL = "Delete";
    private static final String LBL_BTN_DISMISS = "Dismiss";
    private static final String LBL_BTN_OK = "Ok";
    private static final String LBL_BTN_CANCEL = "Cancel";
    private static final String PLUGIN_NONE = "none";
    private static final String PLUGIN_FTP = "ftp";
    private static final String[] PLUGIN_NAMES = new String[]{"none", "ftp"};
    private static final int[] PLUGIN_PORTS = new int[]{0, 21};
    private static SSHPropertyHandler propsHandler;
    private static Frame parent;
    private static SSHInteractiveClient client;
    private static JList tunnelList;
    private static JButton delButton;

    private static void showAddDialog() {
        final JDialog jDialog = SwingConvenience.newBorderJDialog(parent, "Add tunnel", true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        final JRadioButton jRadioButton = new JRadioButton(LBL_LOCAL, true);
        jRadioButton.setActionCommand("local");
        JRadioButton jRadioButton2 = new JRadioButton(LBL_REMOTE);
        jRadioButton2.setActionCommand("remote");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(LBL_TYPE), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        final JRadioButton jRadioButton3 = new JRadioButton(LBL_LOCALHOST, true);
        jRadioButton3.setActionCommand(LBL_LOCALHOST);
        final JRadioButton jRadioButton4 = new JRadioButton(LBL_ALL_HOSTS);
        jRadioButton4.setActionCommand("allhosts");
        JRadioButton jRadioButton5 = new JRadioButton(LBL_IP);
        jRadioButton5.setActionCommand("spechost");
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        jPanel.add((Component)new JLabel(LBL_BIND_ADDR), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jRadioButton4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(jRadioButton5);
        final JTextField jTextField = new JTextField("", 16);
        jTextField.setEnabled(false);
        jPanel2.add(jTextField);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(LBL_SRC_PORT), gridBagConstraints);
        final JTextField jTextField2 = new JTextField("", 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jTextField2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(LBL_DEST_ADDR), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        final JTextField jTextField3 = new JTextField("", 16);
        jPanel.add((Component)jTextField3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(LBL_DEST_PORT), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        final JTextField jTextField4 = new JTextField("", 5);
        jPanel.add((Component)jTextField4, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        final JLabel jLabel = new JLabel(LBL_PLUGIN);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        final JComboBox<String> jComboBox = new JComboBox<String>(PLUGIN_NAMES);
        jPanel.add(jComboBox, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        JButton jButton = new JButton(LBL_BTN_OK);
        jButton.setActionCommand("ok");
        JButton jButton2 = new JButton(LBL_BTN_CANCEL);
        jButton2.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jDialog.getContentPane().add((Component)jPanel, "Center");
        jDialog.getContentPane().add((Component)SwingConvenience.newButtonPanel(new JComponent[]{jButton, jButton2}), "South");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("local".equals(string)) {
                    jLabel.setEnabled(true);
                    jComboBox.setEnabled(true);
                } else if ("remote".equals(string)) {
                    jLabel.setEnabled(false);
                    jComboBox.setEnabled(false);
                    jComboBox.setSelectedIndex(0);
                } else if (SSHTunnelDialogSwing.LBL_LOCALHOST.equals(string)) {
                    jTextField.setEnabled(false);
                    jTextField.setText("");
                } else if ("allhosts".equals(string)) {
                    jTextField.setEnabled(false);
                    jTextField.setText("");
                } else if ("spechost".equals(string)) {
                    jTextField.setEnabled(true);
                } else if ("ok".equals(string)) {
                    String string2;
                    int n = -1;
                    int n2 = -1;
                    try {
                        n = Integer.valueOf(jTextField2.getText());
                        n2 = Integer.valueOf(jTextField4.getText());
                        if (n < 1 || n > 65535) {
                            n = -1;
                            throw new NumberFormatException();
                        }
                        if (n2 < 1 || n2 > 65535) {
                            n2 = -1;
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n == -1) {
                            jTextField2.setText("");
                            jTextField2.requestFocus();
                        } else {
                            jTextField4.setText("");
                            jTextField4.requestFocus();
                        }
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    String string3 = (String)jComboBox.getSelectedItem();
                    if (string3.equals(SSHTunnelDialogSwing.PLUGIN_NONE)) {
                        string3 = "general";
                    }
                    if ((string2 = jTextField3.getText().trim()).equals("")) {
                        jTextField4.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    try {
                        String string4 = jRadioButton.isSelected() ? "local" + client.localForwards.size() : "remote" + client.remoteForwards.size();
                        String string5 = "";
                        if (jRadioButton3.isSelected()) {
                            string5 = "127.0.0.1";
                        } else if (jRadioButton4.isSelected()) {
                            string5 = "0.0.0.0";
                        } else {
                            string5 = jTextField.getText().trim();
                            if (string5.equals("")) {
                                jTextField.requestFocus();
                                Toolkit.getDefaultToolkit().beep();
                                return;
                            }
                        }
                        propsHandler.setProperty(string4, "/" + string3 + "/" + string5 + ":" + n + ":" + string2 + ":" + n2);
                    }
                    catch (Throwable throwable) {
                        SSHMiscDialogs.alert("Tunnel Notice", "Could not open tunnel: " + throwable.getMessage(), parent);
                        return;
                    }
                    jDialog.dispose();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jRadioButton.addActionListener(actionListener);
        jRadioButton2.addActionListener(actionListener);
        jRadioButton3.addActionListener(actionListener);
        jRadioButton4.addActionListener(actionListener);
        jRadioButton5.addActionListener(actionListener);
        jTextField2.requestFocus();
        jDialog.setResizable(false);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    public static void show(String string, SSHInteractiveClient sSHInteractiveClient, SSHPropertyHandler sSHPropertyHandler, Frame frame) {
        propsHandler = sSHPropertyHandler;
        parent = frame;
        client = sSHInteractiveClient;
        JDialog jDialog = SwingConvenience.newBorderJDialog(parent, string, true);
        Action action = new Action();
        tunnelList = new JList();
        tunnelList.setVisibleRowCount(8);
        tunnelList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(tunnelList);
        jDialog.getContentPane().add((Component)jScrollPane, "Center");
        tunnelList.addListSelectionListener(action);
        JButton jButton = new JButton(LBL_BTN_ADD);
        jButton.setActionCommand("add");
        jButton.addActionListener(action);
        delButton = new JButton(LBL_BTN_DEL);
        delButton.setActionCommand("del");
        delButton.addActionListener(action);
        delButton.setEnabled(false);
        JButton jButton2 = new JButton(LBL_BTN_DISMISS);
        jButton2.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jDialog.getContentPane().add((Component)SwingConvenience.newButtonPanel(new JComponent[]{new JLabel(""), new JLabel(""), jButton, delButton, jButton2}), "South");
        SSHTunnelDialogSwing.updateTunnelList();
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    private static void updateTunnelList() {
        Object object;
        int n;
        int n2 = SSHTunnelDialogSwing.client.localForwards.size();
        int n3 = SSHTunnelDialogSwing.client.remoteForwards.size();
        String[] stringArray = new String[n2 + n3];
        for (n = 0; n < n2; ++n) {
            object = (SSHClient.LocalForward)SSHTunnelDialogSwing.client.localForwards.elementAt(n);
            String string = ((SSHClient.LocalForward)object).plugin.equals("general") ? "" : " (plugin: " + ((SSHClient.LocalForward)object).plugin + ")";
            stringArray[n] = "L: " + ((SSHClient.LocalForward)object).localHost + ":" + ((SSHClient.LocalForward)object).localPort + " --> " + ((SSHClient.LocalForward)object).remoteHost + ":" + ((SSHClient.LocalForward)object).remotePort + string;
        }
        for (n = 0; n < n3; ++n) {
            object = (SSHClient.RemoteForward)SSHTunnelDialogSwing.client.remoteForwards.elementAt(n);
            stringArray[n + n2] = "R: " + ((SSHClient.RemoteForward)object).localHost + ":" + ((SSHClient.RemoteForward)object).localPort + " <-- " + ((SSHClient.RemoteForward)object).remoteHost + ":" + ((SSHClient.RemoteForward)object).remotePort;
        }
        tunnelList.setListData(stringArray);
    }

    private static class Action
    implements ActionListener,
    ItemListener,
    ListSelectionListener {
        private Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("add".equals(string)) {
                SSHTunnelDialogSwing.showAddDialog();
            } else if ("del".equals(string)) {
                int n = tunnelList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                int n2 = client.localForwards.size();
                if (n < n2) {
                    propsHandler.removeLocalTunnelAt(n, true);
                } else {
                    propsHandler.removeRemoteTunnelAt(n - n2);
                }
            }
            SSHTunnelDialogSwing.updateTunnelList();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = tunnelList.getSelectedIndex();
            delButton.setEnabled(n >= 0);
        }
    }
}

