/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.isnetworks.ssh.AbstractFileBrowser;
import com.isnetworks.ssh.FileDisplayControl;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.sshcommon.SSHConsoleRemote;
import com.mindbright.util.ExpectOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class SSHRemoteFileBrowsingConsole
extends AbstractFileBrowser
implements ExpectOutputStream.Expector {
    private SSHConsoleRemote remote;
    private OutputStream stdin;
    private String remoteLSCommand;
    private String mCurrentDirectory;

    public SSHRemoteFileBrowsingConsole(FileDisplayControl fileDisplayControl, String string, SSHConsoleRemote sSHConsoleRemote, String string2) {
        super(fileDisplayControl);
        this.remoteLSCommand = string;
        this.remote = sSHConsoleRemote;
        this.mCurrentDirectory = string2;
    }

    public void initialize() throws Exception {
        if (!this.remote.shell()) {
            throw new Exception("Error when connecting with remote machine");
        }
        this.stdin = this.remote.getStdIn();
        this.remote.changeStdOut(new ExpectOutputStream(this, "___END_LS___"));
        this.changeDirectory(this.mCurrentDirectory);
        this.refresh();
    }

    public void disconnect() {
        this.remote.close();
    }

    public void refresh() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("echo ___START_PWD___\n");
        stringBuffer.append("pwd\n");
        stringBuffer.append(this.remoteLSCommand);
        stringBuffer.append("echo ___END_LS___\n");
        this.doCommand(stringBuffer);
    }

    public void makeDirectory(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mkdir \"");
        stringBuffer.append(string);
        stringBuffer.append("\"\n");
        this.doCommand(stringBuffer);
    }

    public void rename(FileListItem fileListItem, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mv \"");
        stringBuffer.append(fileListItem.getAbsolutePath());
        stringBuffer.append("\" \"");
        stringBuffer.append(fileListItem.getParent());
        stringBuffer.append(string);
        stringBuffer.append("\"\n");
        this.doCommand(stringBuffer);
    }

    public void changeDirectory(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cd \"");
        stringBuffer.append(string);
        stringBuffer.append("\"\n");
        this.doCommand(stringBuffer);
    }

    public void delete(FileListItem[] fileListItemArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileListItemArray.length; ++i) {
            if (fileListItemArray[i].isDirectory()) {
                stringBuffer.append("rmdir \"");
            } else {
                stringBuffer.append("rm -f \"");
            }
            stringBuffer.append(fileListItemArray[i].getAbsolutePath());
            stringBuffer.append("\"\n");
        }
        this.doCommand(stringBuffer);
    }

    public void doCommand(StringBuffer stringBuffer) throws Exception {
        try {
            this.stdin.write(stringBuffer.toString().getBytes());
        }
        catch (IOException iOException) {
            throw new Exception("Error sending command to remote machine");
        }
    }

    public void fileDoubleClicked(FileListItem fileListItem) throws Exception {
        if (fileListItem != null && fileListItem.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("cd \"");
            stringBuffer.append(fileListItem.getAbsolutePath());
            stringBuffer.append("\"\n");
            this.doCommand(stringBuffer);
        }
    }

    public void reached(ExpectOutputStream expectOutputStream, byte[] byArray, int n) {
        String string = new String(byArray, 0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = stringTokenizer.nextToken();
        while (string2.indexOf("___START_PWD___") == -1) {
            string2 = stringTokenizer.nextToken();
        }
        this.mCurrentDirectory = stringTokenizer.nextToken();
        if (!this.mCurrentDirectory.endsWith("/")) {
            this.mCurrentDirectory = this.mCurrentDirectory + "/";
        }
        if (!this.mCurrentDirectory.equals("/")) {
            this.dirs.addElement(new FileListItem("..", this.mCurrentDirectory, true, "/"));
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            boolean bl = string2.endsWith("/");
            boolean bl2 = bl || string2.endsWith("@") || string2.endsWith("*");
            String string3 = bl2 ? string2.substring(0, string2.length() - 1) : string2;
            FileListItem fileListItem = new FileListItem(string3, this.mCurrentDirectory, bl, "/");
            if (bl) {
                this.dirs.addElement(fileListItem);
                continue;
            }
            this.files.addElement(fileListItem);
        }
        this.mFileDisplay.setFileList(this.dirs, this.files, this.mCurrentDirectory, "/");
    }

    public void closed(ExpectOutputStream expectOutputStream, byte[] byArray, int n) {
    }
}

