/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.interfaces.RSAPrivateCrtKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.security.publickey.RSAAlgorithm;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHAuthenticator;
import com.mindbright.ssh.SSHChannelController;
import com.mindbright.ssh.SSHClientUser;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHConsole;
import com.mindbright.ssh.SSHInteractor;
import com.mindbright.ssh.SSHPduInputStream;
import com.mindbright.ssh.SSHPduOutputStream;
import com.mindbright.ssh.SSHProtocolPlugin;
import com.mindbright.ssh.SSHRSAKeyFile;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.util.SecureRandomAndPad;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class SSHClient
extends SSH {
    protected Thread myThread;
    protected KeepAliveThread keepAliveThread;
    protected SecureRandomAndPad rand;
    protected InetAddress serverAddr;
    protected InetAddress serverRealAddr;
    protected InetAddress localAddr;
    protected String srvVersionStr;
    protected int srvVersionMajor;
    protected int srvVersionMinor;
    protected Vector localForwards;
    protected Vector remoteForwards;
    protected String commandLine;
    protected SSHChannelController controller;
    protected SSHConsole console;
    protected SSHAuthenticator authenticator;
    protected SSHClientUser user;
    protected SSHInteractor interactor;
    protected Socket sshSocket;
    protected BufferedInputStream sshIn;
    protected BufferedOutputStream sshOut;
    protected boolean gracefulExit;
    protected boolean isConnected;
    protected boolean isOpened;
    boolean usedOTP;
    protected int refCount;
    protected boolean havePORTFtp;
    protected int firstFTPPort;
    protected boolean activateTunnels;
    private static final int CANNOT_CHOOSE_PIN = 0;
    private static final int USER_SELECTABLE = 1;
    private static final int MUST_CHOOSE_PIN = 2;

    public SSHClient(SSHAuthenticator sSHAuthenticator, SSHClientUser sSHClientUser) {
        block2: {
            this.serverRealAddr = null;
            this.havePORTFtp = false;
            this.firstFTPPort = 0;
            this.activateTunnels = true;
            this.user = sSHClientUser;
            this.authenticator = sSHAuthenticator;
            this.interactor = sSHClientUser.getInteractor();
            this.srvVersionStr = null;
            this.refCount = 0;
            this.usedOTP = false;
            try {
                this.localAddr = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                if (this.interactor == null) break block2;
                this.interactor.alert("FATAL: Could not create local InetAddress: " + unknownHostException.getMessage());
            }
        }
        this.clearAllForwards();
    }

    public void setConsole(SSHConsole sSHConsole) {
        this.console = sSHConsole;
        if (this.controller != null) {
            this.controller.console = sSHConsole;
        }
    }

    public SSHConsole getConsole() {
        return this.console;
    }

    public InetAddress getServerAddr() {
        return this.serverAddr;
    }

    public InetAddress getServerRealAddr() {
        if (this.serverRealAddr == null) {
            return this.serverAddr;
        }
        return this.serverRealAddr;
    }

    public void setServerRealAddr(InetAddress inetAddress) {
        this.serverRealAddr = inetAddress;
    }

    public InetAddress getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String string) throws UnknownHostException {
        this.localAddr = InetAddress.getByName(string);
    }

    public String getServerVersion() {
        return this.srvVersionStr;
    }

    public void addLocalPortForward(int n, String string, int n2, String string2) throws IOException {
        this.addLocalPortForward(this.localAddr.getHostAddress(), n, string, n2, string2);
    }

    public void addLocalPortForward(String string, int n, String string2, int n2, String string3) throws IOException {
        this.delLocalPortForward(string, n);
        this.localForwards.addElement(new LocalForward(string, n, string2, n2, string3));
        if (this.isOpened) {
            try {
                this.requestLocalPortForward(string, n, string2, n2, string3);
            }
            catch (IOException iOException) {
                this.delLocalPortForward(string, n);
                throw iOException;
            }
        }
    }

    public void delLocalPortForward(String string, int n) {
        if (n == -1) {
            if (this.isOpened) {
                this.controller.killListenChannels();
            }
            this.localForwards = new Vector();
        } else {
            for (int i = 0; i < this.localForwards.size(); ++i) {
                LocalForward localForward = (LocalForward)this.localForwards.elementAt(i);
                if (localForward.localPort != n || !localForward.localHost.equals(string)) continue;
                this.localForwards.removeElementAt(i);
                if (!this.isOpened) break;
                this.controller.killListenChannel(localForward.localHost, localForward.localPort);
                break;
            }
        }
    }

    public void addRemotePortForward(String string, int n, String string2, int n2, String string3) {
        this.delRemotePortForward(string, n);
        this.remoteForwards.addElement(new RemoteForward(string, n, string2, n2, string3));
    }

    public void delRemotePortForward(String string, int n) {
        if (n == -1) {
            this.remoteForwards = new Vector();
        } else {
            for (int i = 0; i < this.remoteForwards.size(); ++i) {
                RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(i);
                if (remoteForward.remotePort != n || !remoteForward.remoteHost.equals(string)) continue;
                this.remoteForwards.removeElementAt(i);
                break;
            }
        }
    }

    public void delRemotePortForward(String string) {
        for (int i = 0; i < this.remoteForwards.size(); ++i) {
            RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(i);
            if (!remoteForward.plugin.equals(string)) continue;
            this.remoteForwards.removeElementAt(i);
            --i;
        }
    }

    public void clearAllForwards() {
        this.localForwards = new Vector();
        this.remoteForwards = new Vector();
    }

    public void startExitMonitor() {
        this.startExitMonitor(0L);
    }

    public void startExitMonitor(long l) {
        Thread thread = new Thread(new ExitMonitor(this, l));
        thread.setName("ExitMonitor");
        thread.start();
    }

    public synchronized int addRef() {
        return ++this.refCount;
    }

    public void forcedDisconnect() {
        if (this.controller != null) {
            this.controller.sendDisconnect("exit");
            this.controller.killAll();
        } else if (this.interactor != null) {
            this.interactor.disconnected(this, false);
        }
    }

    public synchronized int delRef() {
        if (--this.refCount <= 0) {
            this.forcedDisconnect();
            this.waitForExit(2000L);
        }
        return this.refCount;
    }

    public void waitForExit(long l) {
        try {
            this.controller.waitForExit(l);
        }
        catch (InterruptedException interruptedException) {
            if (this.interactor != null) {
                this.interactor.alert("Error when shutting down SSHClient: " + interruptedException.getMessage());
            }
            this.controller.killAll();
        }
        try {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doSingleCommand(String string, boolean bl, long l) throws IOException {
        this.commandLine = string;
        this.bootSSH(false);
        if (bl) {
            this.startExitMonitor(l);
        } else {
            this.waitForExit(l);
        }
    }

    public void bootSSH(boolean bl) throws IOException {
        this.bootSSH(bl, false);
    }

    public void bootSSH(boolean bl, boolean bl2) throws IOException {
        try {
            this.myThread = Thread.currentThread();
            this.rand = this.secureRandom();
            if (this.interactor != null) {
                this.interactor.startNewSession(this);
            }
            String string = this.user.getSrvHost();
            if (this.interactor != null) {
                this.interactor.sessionStarted(this);
            }
            this.sshSocket = this.user.getProxyConnection();
            if (this.sshSocket == null) {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                for (int i = 0; this.sshSocket == null && i < inetAddressArray.length; ++i) {
                    this.serverAddr = inetAddressArray[i];
                    if (SSH.DEBUG) {
                        System.out.println("Connecting to " + this.serverAddr.getHostAddress() + ":" + this.user.getSrvPort());
                    }
                    this.sshSocket = new Socket(this.serverAddr, this.user.getSrvPort());
                }
            } else {
                this.serverAddr = this.sshSocket.getInetAddress();
                if (this.interactor != null) {
                    this.interactor.report("Connecting through proxy at " + this.serverAddr.getHostAddress() + ":" + this.sshSocket.getPort());
                }
            }
            if (bl2) {
                return;
            }
            this.boot(bl, this.sshSocket);
        }
        catch (IOException iOException) {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
            this.disconnect(false);
            if (this.controller != null) {
                this.controller.killListenChannels();
            }
            this.controller = null;
            throw iOException;
        }
    }

    public void boot(boolean bl, Socket socket) throws IOException {
        try {
            this.sshSocket = socket;
            this.sshIn = new BufferedInputStream(this.sshSocket.getInputStream(), 8192);
            this.sshOut = new BufferedOutputStream(this.sshSocket.getOutputStream());
            this.negotiateVersion();
            this.isConnected = true;
            if (this.interactor != null) {
                this.interactor.connected(this);
            }
            String string = this.authenticator.getUsername(this.user);
            this.receiveServerData();
            this.initiatePlugins();
            this.cipherType = this.authenticator.getCipher(this.user);
            if (!this.isCipherSupported(this.cipherType)) {
                throw new IOException("Sorry, server does not support the '" + SSH.getCipherName(this.authenticator.getCipher(this.user)) + "' cipher.");
            }
            this.generateSessionId();
            this.generateSessionKey();
            this.initClientCipher();
            this.sendSessionKey(this.cipherType);
            this.authenticateUser(string);
            this.requestCompression(this.user.getCompressionLevel());
            this.controller = new SSHChannelController(this, this.sshIn, this.sshOut, this.sndCipher, this.sndComp, this.rcvCipher, this.rcvComp, this.console, bl);
            this.initiateSession();
            if (this.console != null) {
                this.console.serverConnect(this.controller, this.sndCipher);
            }
            this.isOpened = true;
            if (this.interactor != null) {
                this.interactor.open(this);
            }
            this.setAliveInterval(this.user.getAliveInterval());
            this.controller.start();
        }
        catch (IOException iOException) {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
            this.disconnect(false);
            if (this.controller != null) {
                this.controller.killListenChannels();
            }
            this.controller = null;
            throw iOException;
        }
    }

    protected void disconnect(boolean bl) {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        this.isOpened = false;
        this.gracefulExit = bl;
        this.srvVersionStr = null;
        this.setAliveInterval(0);
        if (this.interactor != null) {
            this.interactor.disconnected(this, bl);
            String string = "";
            if (this.sndComp != null || this.rcvComp != null) {
                for (int i = 0; i < 2; ++i) {
                    SSHCompressor sSHCompressor;
                    SSHCompressor sSHCompressor2 = sSHCompressor = i == 0 ? this.sndComp : this.rcvComp;
                    if (sSHCompressor == null) continue;
                    long l = sSHCompressor.numOfCompressedBytes();
                    long l2 = sSHCompressor.numOfUncompressedBytes();
                    string = string + (i == 0 ? "outgoing" : "\r\nincoming") + " raw data (bytes) = " + l2 + ", compressed = " + l + " (" + l * 100L / l2 + "%)";
                }
                this.interactor.report(string);
            }
        }
        this.sndComp = null;
        this.rcvComp = null;
    }

    void negotiateVersion() throws IOException {
        byte[] byArray = new byte[256];
        try {
            int n = this.sshIn.read(byArray);
            this.srvVersionStr = new String(byArray, 0, n);
        }
        catch (Throwable throwable) {
            throw new IOException("Could not negotiate SSH version with server");
        }
        try {
            int n = this.srvVersionStr.indexOf(45);
            int n2 = this.srvVersionStr.indexOf(46);
            this.srvVersionMajor = Integer.parseInt(this.srvVersionStr.substring(n + 1, n2));
            n = n2;
            n2 = this.srvVersionStr.indexOf(45, n);
            this.srvVersionMinor = n2 == -1 ? Integer.parseInt(this.srvVersionStr.substring(n + 1)) : Integer.parseInt(this.srvVersionStr.substring(n + 1, n2));
        }
        catch (Throwable throwable) {
            throw new IOException("Server version string invalid: " + this.srvVersionStr);
        }
        if (this.srvVersionMajor > 1) {
            throw new IOException("This server doesn't support ssh1, connect with ssh2 enabled");
        }
        if (this.srvVersionMajor < 1 || this.srvVersionMinor < 5) {
            throw new IOException("Server's protocol version (" + this.srvVersionMajor + "-" + this.srvVersionMinor + ") is too old, please upgrade");
        }
        this.srvVersionStr = this.srvVersionStr.trim();
        String string = this.getVersionId(true);
        string = string + "\n";
        byArray = string.getBytes();
        this.sshOut.write(byArray);
        this.sshOut.flush();
    }

    void receiveServerData() throws IOException {
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(2, null, null);
        sSHPduInputStream.readFrom(this.sshIn);
        this.srvCookie = new byte[8];
        sSHPduInputStream.read(this.srvCookie, 0, 8);
        int n = sSHPduInputStream.readInt();
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        BigInteger bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvServerKey = new com.mindbright.security.publickey.RSAPublicKey(bigInteger2, bigInteger);
        n = sSHPduInputStream.readInt();
        bigInteger = sSHPduInputStream.readBigInteger();
        bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvHostKey = new com.mindbright.security.publickey.RSAPublicKey(bigInteger2, bigInteger);
        int n2 = Math.abs(this.srvServerKey.getModulus().bitLength() - this.srvHostKey.getModulus().bitLength());
        if (n2 < 24) {
            throw new IOException("Invalid server keys, difference in sizes must be at least 24 bits");
        }
        if (!this.authenticator.verifyKnownHosts(this.srvHostKey)) {
            throw new IOException("Verification of known hosts failed");
        }
        this.protocolFlags = sSHPduInputStream.readInt();
        this.supportedCiphers = sSHPduInputStream.readInt();
        this.supportedAuthTypes = sSHPduInputStream.readInt();
        if ((this.supportedAuthTypes & 0x10000) != 0) {
            this.supportedAuthTypes = this.supportedAuthTypes & 0xFFFF | 0x100;
        }
    }

    void generateSessionKey() {
        this.sessionKey = new byte[32];
        this.rand.nextBytes(this.sessionKey);
    }

    void sendSessionKey(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[this.sessionKey.length + 1];
        byArray[0] = 0;
        System.arraycopy(this.sessionKey, 0, byArray, 1, this.sessionKey.length);
        for (n2 = 0; n2 < this.sessionId.length; ++n2) {
            int n3 = n2 + 1;
            byArray[n3] = (byte)(byArray[n3] ^ this.sessionId[n2]);
        }
        BigInteger bigInteger = new BigInteger(byArray);
        n2 = (this.srvServerKey.getModulus().bitLength() + 7) / 8;
        int n4 = (this.srvHostKey.getModulus().bitLength() + 7) / 8;
        try {
            if (n2 < n4) {
                BigInteger bigInteger2 = RSAAlgorithm.addPKCS1Pad(bigInteger, 2, n2, this.rand);
                bigInteger = RSAAlgorithm.doPublic(bigInteger2, this.srvServerKey.getModulus(), this.srvServerKey.getPublicExponent());
                bigInteger2 = RSAAlgorithm.addPKCS1Pad(bigInteger, 2, n4, this.rand);
                bigInteger = RSAAlgorithm.doPublic(bigInteger2, this.srvHostKey.getModulus(), this.srvHostKey.getPublicExponent());
            } else {
                BigInteger bigInteger3 = RSAAlgorithm.addPKCS1Pad(bigInteger, 2, n4, this.rand);
                bigInteger = RSAAlgorithm.doPublic(bigInteger3, this.srvHostKey.getModulus(), this.srvHostKey.getPublicExponent());
                bigInteger3 = RSAAlgorithm.addPKCS1Pad(bigInteger, 2, n2, this.rand);
                bigInteger = RSAAlgorithm.doPublic(bigInteger3, this.srvServerKey.getModulus(), this.srvServerKey.getPublicExponent());
            }
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.getMessage());
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(3, null, null, this.rand);
        sSHPduOutputStream.writeByte((byte)n);
        sSHPduOutputStream.write(this.srvCookie, 0, this.srvCookie.length);
        sSHPduOutputStream.writeBigInteger(bigInteger);
        sSHPduOutputStream.writeInt(this.protocolFlags);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new IOException("Error while sending session key!");
        }
    }

    void authenticateUser(String string) throws IOException {
        this.usedOTP = false;
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(4, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (this.isSuccess()) {
            if (this.interactor != null) {
                this.interactor.report("Authenticated directly by server, no other authentication required");
            }
            return;
        }
        int[] nArray = this.authenticator.getAuthTypes(this.user);
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (!this.isAuthTypeSupported(nArray[i])) {
                    throw new AuthFailException("server does not support '" + SSH.authTypeDesc[nArray[i]] + "'");
                }
                switch (nArray[i]) {
                    case 2: {
                        this.doRSAAuth(false, string);
                        break;
                    }
                    case 3: {
                        this.doPasswdAuth(string);
                        break;
                    }
                    case 4: {
                        this.doRSAAuth(true, string);
                        break;
                    }
                    case 5: {
                        this.doTISAuth(string);
                        break;
                    }
                    case 1: {
                        this.doRhostsAuth(string);
                        break;
                    }
                    case 8: {
                        this.doSDIAuth(string);
                        this.usedOTP = true;
                        break;
                    }
                    default: {
                        throw new IOException("We do not support selected authentication type " + SSH.authTypeDesc[nArray[i]]);
                    }
                }
                return;
            }
            catch (AuthFailException authFailException) {
                if (i == nArray.length - 1) {
                    throw authFailException;
                }
                if (this.interactor == null) continue;
                this.interactor.report("Authenticating with " + SSH.authTypeDesc[nArray[i]] + " failed, " + authFailException.getMessage());
                continue;
            }
        }
    }

    void doPasswdAuth(String string) throws IOException {
        String string2 = this.authenticator.getPassword(this.user);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(9, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException();
        }
    }

    void doRhostsAuth(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(5, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException();
        }
    }

    void doTISAuth(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(39, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher, this.rcvComp);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 15) {
            throw new AuthFailException("TIS authentication server not reachable or user unknown");
        }
        if (sSHPduInputStream.type != 40) {
            throw new IOException("Protocol error, expected TIS challenge but got " + sSHPduInputStream.type);
        }
        String string2 = sSHPduInputStream.readString();
        String string3 = this.authenticator.getChallengeResponse(this.user, string2);
        sSHPduOutputStream = new SSHPduOutputStream(41, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string3);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException();
        }
    }

    void doRSAAuth(boolean bl, String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream;
        SSHRSAKeyFile sSHRSAKeyFile = this.authenticator.getIdentityFile(this.user);
        RSAPublicKey rSAPublicKey = sSHRSAKeyFile.getPublic();
        if (bl) {
            sSHPduOutputStream = new SSHPduOutputStream(35, this.sndCipher, this.sndComp, this.rand);
            sSHPduOutputStream.writeString(string);
            sSHPduOutputStream.writeInt(rSAPublicKey.getModulus().bitLength());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getPublicExponent());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getModulus());
        } else {
            sSHPduOutputStream = new SSHPduOutputStream(6, this.sndCipher, this.sndComp, this.rand);
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getModulus());
        }
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher, this.rcvComp);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 15) {
            throw new AuthFailException("server refused our key" + (bl ? " or rhosts" : ""));
        }
        if (sSHPduInputStream.type != 7) {
            throw new IOException("Protocol error, expected RSA-challenge but got " + sSHPduInputStream.type);
        }
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        RSAPrivateCrtKey rSAPrivateCrtKey = sSHRSAKeyFile.getPrivate("");
        if (rSAPrivateCrtKey == null) {
            rSAPrivateCrtKey = sSHRSAKeyFile.getPrivate(this.authenticator.getIdentityPassword(this.user));
        } else if (this.interactor != null) {
            this.interactor.report("Authenticated with password-less rsa-key '" + sSHRSAKeyFile.getComment() + "'");
        }
        if (rSAPrivateCrtKey == null) {
            throw new AuthFailException("invalid password for key-file '" + sSHRSAKeyFile.getComment() + "'");
        }
        this.rsaChallengeResponse(rSAPrivateCrtKey, bigInteger);
    }

    void doSDIAuth(String string) throws IOException {
        String string2 = this.authenticator.getChallengeResponse(this.user, string + "'s SDI token passcode: ");
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string2);
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher, this.rcvComp);
        sSHPduInputStream.readFrom(this.sshIn);
        block0 : switch (sSHPduInputStream.type) {
            case 14: {
                this.interactor.report("SDI authentication accepted.");
                break;
            }
            case 15: {
                throw new AuthFailException("SDI authentication failed.");
            }
            case 66: {
                string2 = this.interactor.promptPassword("Next token required: ");
                sSHPduOutputStream = new SSHPduOutputStream(67, this.sndCipher, this.sndComp, this.rand);
                sSHPduOutputStream.writeString(string2);
                sSHPduOutputStream.writeTo(this.sshOut);
                if (this.isSuccess()) break;
                throw new AuthFailException();
            }
            case 68: {
                if (!this.interactor.askConfirmation("New PIN required, do you want to continue?", false)) {
                    throw new AuthFailException("new PIN not wanted");
                }
                String string3 = sSHPduInputStream.readString();
                String string4 = sSHPduInputStream.readString();
                int n = sSHPduInputStream.readInt();
                switch (n) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        String string5;
                        while (!(string2 = this.interactor.promptPassword("Please enter new PIN containing " + string4 + " " + string3)).equals(string5 = this.interactor.promptPassword("Please enter new PIN again"))) {
                        }
                        sSHPduOutputStream = new SSHPduOutputStream(71, this.sndCipher, this.sndComp, this.rand);
                        sSHPduOutputStream.writeString(string2);
                        sSHPduOutputStream.writeTo(this.sshOut);
                        sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher, this.rcvComp);
                        sSHPduInputStream.readFrom(this.sshIn);
                        if (sSHPduInputStream.type != 69) {
                            throw new AuthFailException("PIN rejected by server");
                        }
                        throw new AuthFailException("new PIN accepted, wait for the code on your token to change");
                    }
                }
                throw new AuthFailException("invalid response from server");
            }
            default: {
                throw new AuthFailException();
            }
        }
    }

    void rsaChallengeResponse(RSAPrivateCrtKey rSAPrivateCrtKey, BigInteger bigInteger) throws IOException {
        try {
            bigInteger = RSAAlgorithm.doPrivateCrt(bigInteger, rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            bigInteger = RSAAlgorithm.stripPKCS1Pad(bigInteger, 2);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        byte[] byArray = bigInteger.toByteArray();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (byArray[0] == 0) {
                messageDigest.update(byArray, 1, 32);
            } else {
                messageDigest.update(byArray, 0, 32);
            }
            messageDigest.update(this.sessionId);
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("MD5 not implemented, can't generate session-id");
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(8, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.write(byArray, 0, byArray.length);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException();
        }
    }

    void initiateSession() throws IOException {
        int n;
        if (this.user.wantPTY()) {
            this.requestPTY();
        }
        if ((n = this.user.getMaxPacketSz()) > 0) {
            this.requestMaxPacketSz(n);
        }
        if (this.user.wantX11Forward()) {
            this.requestX11Forward();
        }
        if (this.activateTunnels) {
            this.initiateTunnels();
        }
        if (this.commandLine != null) {
            this.requestCommand(this.commandLine);
        } else {
            this.requestShell();
        }
    }

    void initiatePlugins() {
        SSHProtocolPlugin.initiateAll(this);
    }

    void initiateTunnels() throws IOException {
        Object object;
        int n;
        for (n = 0; n < this.localForwards.size(); ++n) {
            object = (LocalForward)this.localForwards.elementAt(n);
            this.requestLocalPortForward(((LocalForward)object).localHost, ((LocalForward)object).localPort, ((LocalForward)object).remoteHost, ((LocalForward)object).remotePort, ((LocalForward)object).plugin);
        }
        for (n = 0; n < this.remoteForwards.size(); ++n) {
            object = (RemoteForward)this.remoteForwards.elementAt(n);
            this.requestRemotePortForward(((RemoteForward)object).remotePort, ((RemoteForward)object).localHost, ((RemoteForward)object).localPort, ((RemoteForward)object).plugin);
        }
    }

    void requestCompression(int n) throws IOException {
        if (n == 0) {
            return;
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(37, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting compression level: " + n);
        }
        this.sndComp = SSHCompressor.getInstance("zlib", 1, n);
        this.rcvComp = SSHCompressor.getInstance("zlib", 2, n);
    }

    void requestMaxPacketSz(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(38, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting max packet size: " + n);
        }
    }

    void requestX11Forward() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(34, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString("MIT-MAGIC-COOKIE-1");
        sSHPduOutputStream.writeString("112233445566778899aabbccddeeff00");
        sSHPduOutputStream.writeInt(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting X11 forward");
        }
    }

    void requestPTY() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(10, this.sndCipher, this.sndComp, this.rand);
        TerminalWindow terminalWindow = null;
        if (this.console != null) {
            terminalWindow = this.console.getTerminal();
        }
        if (terminalWindow != null) {
            sSHPduOutputStream.writeString(terminalWindow.terminalType());
            sSHPduOutputStream.writeInt(terminalWindow.rows());
            sSHPduOutputStream.writeInt(terminalWindow.cols());
            sSHPduOutputStream.writeInt(terminalWindow.vpixels());
            sSHPduOutputStream.writeInt(terminalWindow.hpixels());
        } else {
            sSHPduOutputStream.writeString("");
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
        }
        sSHPduOutputStream.writeByte(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting PTY");
        }
    }

    void requestLocalPortForward(String string, int n, String string2, int n2, String string3) throws IOException {
        this.controller.newListenChannel(string, n, string2, n2, string3);
    }

    void requestRemotePortForward(int n, String string, int n2, String string2) throws IOException {
        try {
            SSHProtocolPlugin.getPlugin(string2).remoteListener(n, string, n2, this.controller);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException("Plugins not available");
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(28, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeInt(n2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting remote port forward: " + string2 + "/" + n + ":" + string + ":" + n2);
        }
    }

    void requestCommand(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(13, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    void requestShell() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(12, this.sndCipher, this.sndComp, this.rand);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    boolean isSuccess() throws IOException {
        boolean bl = false;
        SSHPduInputStream sSHPduInputStream = null;
        sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher, this.rcvComp);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 14) {
            bl = true;
        } else if (sSHPduInputStream.type == 15) {
            bl = false;
        } else {
            if (sSHPduInputStream.type == 1) {
                throw new IOException("Server disconnected: " + sSHPduInputStream.readString());
            }
            throw new IOException("Protocol error: got " + sSHPduInputStream.type + " when expecting success/failure");
        }
        return bl;
    }

    void setInteractive() {
        block2: {
            try {
                this.sshSocket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                if (this.interactor == null) break block2;
                this.interactor.report("Error setting interactive mode: " + socketException.getMessage());
            }
        }
    }

    void setAliveInterval(int n) {
        if (n == 0) {
            if (this.keepAliveThread != null && this.keepAliveThread.isAlive()) {
                this.keepAliveThread.stop();
            }
            this.keepAliveThread = null;
        } else if (this.keepAliveThread != null) {
            this.keepAliveThread.setInterval(n);
        } else {
            this.keepAliveThread = new KeepAliveThread(n);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.start();
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    void stdinWriteChar(char c) throws IOException {
        this.stdinWriteString(String.valueOf(c));
    }

    void stdinWriteString(String string) throws IOException {
        this.stdinWriteString(string.getBytes(), 0, string.length());
    }

    void stdinWriteString(byte[] byArray) throws IOException {
        this.stdinWriteString(byArray, 0, byArray.length);
    }

    void stdinWriteString(byte[] byArray, int n, int n2) throws IOException {
        if (this.isOpened && this.controller != null) {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher, this.sndComp, this.rand);
            sSHPduOutputStream.writeInt(n2);
            sSHPduOutputStream.write(byArray, n, n2);
            this.controller.transmit(sSHPduOutputStream);
        }
    }

    void signalWindowChanged(int n, int n2, int n3, int n4) {
        block3: {
            if (this.isOpened && this.controller != null) {
                try {
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(11, this.sndCipher, this.sndComp, this.rand);
                    sSHPduOutputStream.writeInt(n);
                    sSHPduOutputStream.writeInt(n2);
                    sSHPduOutputStream.writeInt(n3);
                    sSHPduOutputStream.writeInt(n4);
                    this.controller.transmit(sSHPduOutputStream);
                }
                catch (Exception exception) {
                    if (this.interactor == null) break block3;
                    this.interactor.alert("Error when sending sigWinch: " + exception.toString());
                }
            }
        }
    }

    public static class RemoteForward {
        protected String remoteHost;
        protected int remotePort;
        protected String localHost;
        protected int localPort;
        protected String plugin;

        public RemoteForward(String string, int n, String string2, int n2, String string3) {
            this.remoteHost = string;
            this.remotePort = n;
            this.localHost = string2;
            this.localPort = n2;
            this.plugin = string3;
        }
    }

    public static class LocalForward {
        protected String localHost;
        protected int localPort;
        protected String remoteHost;
        protected int remotePort;
        protected String plugin;

        public LocalForward(String string, int n, String string2, int n2, String string3) {
            this.localHost = string;
            this.localPort = n;
            this.remoteHost = string2;
            this.remotePort = n2;
            this.plugin = string3;
        }
    }

    private class KeepAliveThread
    extends Thread {
        int interval;

        public KeepAliveThread(int n) {
            super("SSH1KeepAlive");
            this.interval = n;
        }

        public synchronized void setInterval(int n) {
            this.interval = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int n;
                        KeepAliveThread keepAliveThread = this;
                        synchronized (keepAliveThread) {
                            n = this.interval;
                        }
                        Thread.sleep(1000 * n);
                        if (SSHClient.this.controller == null) continue;
                        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(36, SSHClient.this.controller.sndCipher, SSHClient.this.controller.sndComp, SSHClient.this.rand);
                        sSHPduOutputStream.writeString("heartbeat");
                        SSHClient.this.controller.transmit(sSHPduOutputStream);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    public static class ExitMonitor
    implements Runnable {
        SSHClient client;
        long msTimeout;

        public ExitMonitor(SSHClient sSHClient, long l) {
            this.msTimeout = l;
            this.client = sSHClient;
        }

        public ExitMonitor(SSHClient sSHClient) {
            this(sSHClient, 0L);
        }

        public void run() {
            this.client.waitForExit(this.msTimeout);
            if (!this.client.gracefulExit) {
                this.client.disconnect(false);
            }
        }
    }

    public static class AuthFailException
    extends IOException {
        public AuthFailException(String string) {
            super(string);
        }

        public AuthFailException() {
            this("permission denied");
        }
    }
}

