/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHChannelListener;

public abstract class SSHChannel
extends Thread {
    protected int channelId;
    protected SSHChannelListener listener;

    public SSHChannel(int n) {
        this.setName(this.getClass().getName() + "[" + n + "]");
        this.channelId = n;
        this.listener = null;
    }

    public void setSSHChannelListener(SSHChannelListener sSHChannelListener) {
        this.listener = sSHChannelListener;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public abstract void serviceLoop() throws Exception;

    public void close() {
    }

    public void run() {
        try {
            this.serviceLoop();
        }
        catch (Exception exception) {
            if (SSH.DEBUGMORE) {
                System.out.println("--- channel exit (exception is not an error):");
                exception.printStackTrace();
                System.out.println("---");
            }
            this.close();
            if (this.listener != null) {
                this.listener.close(this);
            }
        }
        catch (ThreadDeath threadDeath) {
            SSH.logExtra("Channel killed " + this.channelId + " " + this);
            throw threadDeath;
        }
    }
}

