/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPrivateKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.security.publickey.BaseSignature;
import com.mindbright.security.publickey.DSAAlgorithm;
import java.math.BigInteger;

public class RawDSAWithSHA1
extends BaseSignature {
    public RawDSAWithSHA1() {
        super("SHA1");
    }

    protected void initVerify() throws InvalidKeyException {
        if (this.publicKey == null || !(this.publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 verify: " + this.publicKey);
        }
    }

    protected void initSign() throws InvalidKeyException {
        if (this.privateKey == null || !(this.privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Wrong key for DSAWithSHA1 sign: " + this.privateKey);
        }
    }

    protected byte[] sign(byte[] byArray) {
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)this.privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        BigInteger bigInteger = dSAPrivateKey.getX();
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        return DSAAlgorithm.sign(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray);
    }

    protected boolean verify(byte[] byArray, byte[] byArray2) {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        BigInteger bigInteger = dSAPublicKey.getY();
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        return DSAAlgorithm.verify(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray, byArray2);
    }
}

