/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.SecureRandom;
import java.math.BigInteger;

public final class DiffieHellman {
    private static final BigInteger one = BigInteger.valueOf(1L);

    public static BigInteger generateX(BigInteger bigInteger, SecureRandom secureRandom) {
        return DiffieHellman.generateX(bigInteger, bigInteger.bitLength(), secureRandom);
    }

    public static BigInteger generateX(BigInteger bigInteger, int n, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        BigInteger bigInteger3 = bigInteger.subtract(one).divide(BigInteger.valueOf(2L));
        while ((bigInteger2 = new BigInteger(n, secureRandom)).compareTo(one) < 0 && bigInteger2.compareTo(bigInteger3) > 0) {
        }
        return bigInteger2;
    }

    public static BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger, bigInteger3);
    }

    public static BigInteger computeKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger, bigInteger3);
    }
}

