/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.KeyAgreementSpi;
import com.mindbright.jce.crypto.SecretKey;
import com.mindbright.jce.crypto.ShortBufferException;
import com.mindbright.security.publickey.DHPrivateKey;
import com.mindbright.security.publickey.DHPublicKey;
import com.mindbright.security.publickey.DiffieHellman;
import java.math.BigInteger;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private DHPrivateKey prvKey;
    private SecureRandom random;
    private BigInteger lastKey;
    private boolean lastPhase;

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement got: " + key);
        }
        this.prvKey = (DHPrivateKey)key;
        this.random = secureRandom;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DHKeyAgreement params not supported: " + algorithmParameterSpec);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Invalid key: " + key);
        }
        this.lastPhase = bl;
        BigInteger bigInteger = ((DHPublicKey)key).getY();
        this.lastKey = DiffieHellman.computeKey(this.prvKey.getX(), bigInteger, this.prvKey.getP());
        return new DHPublicKey(this.lastKey, this.prvKey.getP(), this.prvKey.getG());
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.lastPhase) {
            throw new IllegalStateException("DHKeyAgreement not final");
        }
        byte[] byArray = this.lastKey.toByteArray();
        this.lastPhase = false;
        this.lastKey = null;
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray2.length > byArray.length - n) {
            throw new ShortBufferException("DHKeyAgreement, buffer too small");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new Error("DHKeyAgreement.engineGenerateSecret(String) not implemented");
    }
}

