/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.prng;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.SecureRandomSpi;
import com.mindbright.util.RandomSeed;
import java.math.BigInteger;
import java.util.Random;

public final class BlumBlumShub
extends SecureRandomSpi {
    private static final BigInteger one = BigInteger.valueOf(1L);
    private static final BigInteger two = BigInteger.valueOf(2L);
    private BigInteger n;
    private BigInteger xi;
    private int bitsTotal;
    private int bitsLeft;
    private int entropyBits;
    public static final byte[] N = new byte[]{120, -48, -56, -84, -30, 53, 119, 49, 61, 51, 37, 88, 73, 28, 12, -120, -66, -14, -62, -16, 38, 20, 32, 2, 10, 117, -33, -44, 17, 57, -65, 100, 114, -115, -123, -35, -32, -74, 125, 120, 36, -74, 73, 11, 35, 52, -108, -117, 6, -97, 111, 90, 70, -5, 82, 118, -127, 5, 52, 35, -43, -3, -23, 50, -64, -80, 127, 22, 126, -45, -63, -111, -38, 94, -47, -78, 113, 19, 78, 78, 89, 50, 48, 89, -70, 91, 52, -45, 40, -6, -100, 3, -34, -106, -65, -22, -124, 37, 99, 126, 65, -34, 41, -16, -48, 124, -66, 69, -28, 15, 119, 94, -56, -10, -35, 93, -125, -58, 92, -25, 127, 126, -41, 116, 42, -59, -85, -75};

    public BlumBlumShub(BigInteger bigInteger, byte[] byArray) {
        this.n = bigInteger;
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public BlumBlumShub(byte[] byArray) {
        this(new BigInteger(N), byArray);
    }

    public BlumBlumShub() {
        this(null);
    }

    private int log2(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    private void nextXi() {
        Object object;
        if (this.xi == null) {
            object = new RandomSeed();
            this.engineSetSeed(((RandomSeed)object).getBytes(30));
        }
        this.xi = this.xi.modPow(two, this.n);
        this.bitsLeft = this.bitsTotal;
        object = this.xi.toByteArray();
        this.entropyBits = 0;
        for (int i = 0; i < this.bitsLeft; i += 8) {
            this.entropyBits <<= i;
            this.entropyBits |= object[((Object)object).length - 4 + i] & 0xFF;
        }
        this.entropyBits <<= 32 - this.bitsTotal;
        this.entropyBits >>>= 32 - this.bitsTotal;
    }

    private synchronized int nextBits(int n) {
        int n2 = 0;
        while (n >= this.bitsLeft) {
            n2 <<= this.bitsLeft;
            n2 |= this.entropyBits;
            n -= this.bitsLeft;
            this.nextXi();
        }
        if (n > 0) {
            int n3 = this.entropyBits;
            n2 <<= n;
            n3 <<= 32 - n;
            n2 |= (n3 >>>= 32 - n);
            this.entropyBits >>>= n;
            this.bitsLeft -= n;
        }
        return n2;
    }

    private static BigInteger getBlumInteger(int n, Random random) {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger bigInteger = BigInteger.valueOf(4L);
        BigInteger bigInteger2 = BigInteger.valueOf(3L);
        int n2 = 0;
        do {
            BigInteger bigInteger3;
            if (!(bigInteger3 = new BigInteger(n / 2, 128, random)).mod(bigInteger).equals(bigInteger2)) continue;
            bigIntegerArray[n2++] = bigInteger3;
        } while (n2 < 2);
        return bigIntegerArray[0].multiply(bigIntegerArray[1]);
    }

    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    protected void engineNextBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = this.nextBits(8);
            byArray[i] = (byte)(n & 0xFF);
        }
    }

    protected void engineSetSeed(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            if (this.xi == null) {
                int n = 8 * byArray.length;
                if (n > 160) {
                    n = 160;
                }
                this.bitsTotal = this.log2(n);
            } else {
                messageDigest.update(this.xi.toByteArray());
            }
            messageDigest.update(byArray);
            this.xi = new BigInteger(1, messageDigest.digest());
            while (!this.xi.gcd(this.n).equals(one)) {
                this.xi = this.xi.add(one);
            }
            this.nextXi();
        }
        catch (Exception exception) {
            throw new Error("Error in BlumBlumShub engine: " + exception);
        }
    }
}

