/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.security.cipher.BlockCipher;

public final class IDEA
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private int[] e_key_schedule = new int[52];
    private int[] d_key_schedule = new int[52];

    public int getBlockSize() {
        return 8;
    }

    public synchronized void initializeKey(byte[] byArray) {
        this.ideaExpandKey(byArray, this.e_key_schedule);
        this.ideaInvertKey(this.e_key_schedule, this.d_key_schedule);
    }

    private void ideaExpandKey(byte[] byArray, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 8; ++n) {
            nArray[n] = (byArray[2 * n] & 0xFF) << 8 | byArray[2 * n + 1] & 0xFF;
        }
        n3 = 0;
        for (n = 8; n < 52; ++n) {
            nArray[n2 + ++n3 + 7] = (nArray[n2 + (n3 & 7)] << 9 | nArray[n2 + (n3 + 1 & 7)] >>> 7) & 0xFFFF;
            n2 += n3 & 8;
            n3 &= 7;
        }
    }

    private void ideaInvertKey(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 51;
        int n3 = IDEA.mulInv(nArray[n++]);
        int n4 = -nArray[n++] & 0xFFFF;
        int n5 = -nArray[n++] & 0xFFFF;
        nArray2[n2--] = IDEA.mulInv(nArray[n++]);
        nArray2[n2--] = n5;
        nArray2[n2--] = n4;
        nArray2[n2--] = n3;
        for (int i = 1; i < 8; ++i) {
            n3 = nArray[n++];
            nArray2[n2--] = nArray[n++];
            nArray2[n2--] = n3;
            n3 = IDEA.mulInv(nArray[n++]);
            n4 = -nArray[n++] & 0xFFFF;
            n5 = -nArray[n++] & 0xFFFF;
            nArray2[n2--] = IDEA.mulInv(nArray[n++]);
            nArray2[n2--] = n4;
            nArray2[n2--] = n5;
            nArray2[n2--] = n3;
        }
        n3 = nArray[n++];
        nArray2[n2--] = nArray[n++];
        nArray2[n2--] = n3;
        n3 = IDEA.mulInv(nArray[n++]);
        n4 = -nArray[n++] & 0xFFFF;
        n5 = -nArray[n++] & 0xFFFF;
        nArray2[n2--] = IDEA.mulInv(nArray[n++]);
        nArray2[n2--] = n5;
        nArray2[n2--] = n4;
        nArray2[n2--] = n3;
    }

    private void ideaCipher(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = BlockCipher.getIntMSBO(byArray, n);
        int n7 = BlockCipher.getIntMSBO(byArray, n + 4);
        int n8 = n6 >>> 16;
        int n9 = n6 & 0xFFFF;
        int n10 = n7 >>> 16;
        int n11 = n7 & 0xFFFF;
        for (int i = 0; i < 8; ++i) {
            n8 = IDEA.mul(n8 & 0xFFFF, nArray[n5++]);
            int n12 = n5++;
            int n13 = n5++;
            n11 = IDEA.mul(n11 & 0xFFFF, nArray[n5++]);
            n3 = n8 ^ (n10 += nArray[n13]);
            n4 = (n9 += nArray[n12]) ^ n11;
            n3 = IDEA.mul(n3 & 0xFFFF, nArray[n5++]);
            n4 = n3 + n4;
            n4 = IDEA.mul(n4 & 0xFFFF, nArray[n5++]);
            n8 ^= n4;
            n11 ^= (n3 += n4);
            n3 ^= n9;
            n9 = n4 ^ n10;
            n10 = n3;
        }
        n4 = n9;
        n8 = IDEA.mul(n8 & 0xFFFF, nArray[n5++]);
        n9 = n3 + nArray[n5++];
        n10 = n4 + nArray[n5++] & 0xFFFF;
        n11 = IDEA.mul(n11 & 0xFFFF, nArray[n5]);
        BlockCipher.putIntMSBO(n8 << 16 | n9 & 0xFFFF, byArray2, n2);
        BlockCipher.putIntMSBO(n10 << 16 | n11 & 0xFFFF, byArray2, n2 + 4);
    }

    public void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.ideaCipher(byArray, n, byArray2, n2, this.e_key_schedule);
    }

    public void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.ideaCipher(byArray, n, byArray2, n2, this.d_key_schedule);
    }

    private static final int mul(int n, int n2) {
        int n3 = n * n2;
        if (n3 != 0) {
            int n4;
            int n5;
            return n5 - n4 + ((n5 = n3 & 0xFFFF) < (n4 = n3 >>> 16 & 0xFFFF) ? 1 : 0);
        }
        if (n == 0) {
            return 1 - n2;
        }
        return 1 - n;
    }

    private static final int mulInv(int n) {
        if (n <= 1) {
            return n;
        }
        int n2 = 65537 / n;
        int n3 = 65537 % n;
        if (n3 == 1) {
            return 1 - n2 & 0xFFFF;
        }
        int n4 = 1;
        do {
            int n5 = n / n3;
            n4 += n5 * n2;
            if ((n %= n3) == 1) {
                return n4;
            }
            n5 = n3 / n;
            n2 += n5 * n4;
        } while ((n3 %= n) != 1);
        return 1 - n2 & 0xFFFF;
    }
}

