/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jce.crypto;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.KeyAgreementSpi;
import com.mindbright.jce.crypto.SecretKey;
import com.mindbright.jce.crypto.ShortBufferException;

public class KeyAgreement {
    protected KeyAgreementSpi keyAgreementSpi;
    Provider provider;
    String algorithm;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.keyAgreementSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("KeyAgreement", string);
            return KeyAgreement.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Signature: " + noSuchProviderException);
        }
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("KeyAgreement", string, string2);
        return new KeyAgreement((KeyAgreementSpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, (SecureRandom)null);
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.keyAgreementSpi.engineInit(key, secureRandom);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key, algorithmParameterSpec, null);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyAgreementSpi.engineInit(key, algorithmParameterSpec, secureRandom);
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        return this.keyAgreementSpi.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.keyAgreementSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        return this.keyAgreementSpi.engineGenerateSecret(byArray, n);
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.keyAgreementSpi.engineGenerateSecret(string);
    }
}

