/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.MessageDigestSpi;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;

public abstract class MessageDigest
extends MessageDigestSpi {
    protected String algorithm;
    protected Provider provider;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("MessageDigest", string);
            return MessageDigest.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in MessageDigest: " + noSuchProviderException);
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("MessageDigest", string, string2);
        MessageDigest messageDigest = (MessageDigest)providerLookup.getImpl();
        messageDigest.provider = providerLookup.getProvider();
        messageDigest.engineReset();
        return messageDigest;
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public byte[] digest(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
        return this.engineDigest();
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.engineDigest(byArray, n, n2);
    }

    public void reset() {
        this.engineReset();
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.provider.getName() + " (" + this.provider.getVersion() + ") MessageDigest." + this.algorithm;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

