/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.ModuleBaseTerminal;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.ssh2.SSH2TerminalAdapterImpl;
import com.mindbright.terminal.TerminalFrameTitle;
import com.mindbright.terminal.TerminalWindow;
import java.awt.Frame;

public class ModuleTerminalImpl
extends ModuleBaseTerminal {
    private SSH2SessionChannel session;

    public void runTerminal(MindTermApp mindTermApp, TerminalWindow terminalWindow, Frame frame, TerminalFrameTitle terminalFrameTitle) {
        SSH2TerminalAdapterImpl sSH2TerminalAdapterImpl = new SSH2TerminalAdapterImpl(terminalWindow);
        this.session = mindTermApp.getConnection().newTerminal(sSH2TerminalAdapterImpl);
        if (this.useChaff()) {
            sSH2TerminalAdapterImpl.startChaff();
        }
        if (this.session.openStatus() != 1) {
            mindTermApp.alert("Failed to open session channel");
            frame.dispose();
            return;
        }
        boolean bl = Boolean.valueOf(mindTermApp.getProperty("x11-forward"));
        if (bl) {
            mindTermApp.getTransport().getLog().info(mindTermApp.getAppName(), "got X11 forward? " + this.session.requestX11Forward(false, 0));
        }
        mindTermApp.getTransport().getLog().info(mindTermApp.getAppName(), "got pty? " + this.session.requestPTY(terminalWindow.terminalType(), terminalWindow.rows(), terminalWindow.cols(), null));
        mindTermApp.getTransport().getLog().info(mindTermApp.getAppName(), "got shell? " + this.session.doShell());
        this.session.waitForExit(0L);
        sSH2TerminalAdapterImpl.stopChaff();
    }

    protected boolean closeOnDisconnect() {
        return true;
    }

    public String getTitle() {
        return this.mindterm.getUserName() + "@" + this.mindterm.getHost() + (this.mindterm.getPort() != 22 ? ":" + this.mindterm.getPort() : "");
    }

    public boolean isAvailable(MindTermApp mindTermApp) {
        return mindTermApp.isConnected();
    }

    protected boolean haveMenus() {
        return Boolean.valueOf(this.mindterm.getProperty("module.terminal.havemenus"));
    }

    public void doClose() {
        if (this.session != null) {
            this.session.doExit(0);
        }
    }

    protected ModuleBaseTerminal newInstance() {
        return new ModuleTerminalImpl();
    }
}

