<# 
  RESET GRACE PERIOD RDS - SOLO LAB/TEST
  - Legge giorni residui
  - Take ownership + FullControl su HKLM\...\RCM\GracePeriod
  - Elimina la chiave (reset a 120 gg)
  - Riavvia TermService
  - (Opzionale) Riavvio server con conferma
#>

Clear-Host
$ErrorActionPreference = 'Stop'

Write-Host '======================================================' -ForegroundColor Yellow
Write-Host 'ATTENZIONE: SOLO PER LAB/TEST — NON IN PRODUZIONE' 		-ForegroundColor Yellow
Write-Host '======================================================' -ForegroundColor Yellow

function Get-GraceDays {
  try {
    $obj = Get-WmiObject -Namespace root\cimv2\terminalservices -Class Win32_TerminalServiceSetting
    $res = Invoke-WmiMethod -Path $obj.__PATH -Name GetGracePeriodDays
    return [int]$res.DaysLeft
  } catch { return $null }
}

# Stato iniziale
$before = Get-GraceDays
Write-Host "`nGiorni di GRACE rimanenti (prima): $before" -ForegroundColor Green

# Conferma reset
$resp = Read-Host "Reimpostare il Grace Period a 120 giorni? (Y/N)"
if ($resp -notmatch '^(y|s)$') {
  Write-Host "`nOperazione annullata." -ForegroundColor Yellow
  return
}

# Abilita SeTakeOwnershipPrivilege (fallback)
$enablePrivilege = @"
using System;
using System.Runtime.InteropServices;
public static class NtPriv {
  [DllImport("ntdll.dll", EntryPoint="RtlAdjustPrivilege")]
  public static extern int RtlAdjustPrivilege(ulong Privilege, bool Enable, bool CurrentThread, ref bool Enabled);
}
"@
try { Add-Type -TypeDefinition $enablePrivilege -ErrorAction SilentlyContinue } catch {}
$dummy = $false
try { [NtPriv]::RtlAdjustPrivilege(9, $true, $false, [ref]$dummy) | Out-Null } catch {}

# Take ownership + FullControl + delete key
$regPath = 'SYSTEM\CurrentControlSet\Control\Terminal Server\RCM\GracePeriod'
try {
  $key = [Microsoft.Win32.Registry]::LocalMachine.OpenSubKey(
    $regPath,
    [Microsoft.Win32.RegistryKeyPermissionCheck]::ReadWriteSubTree,
    [System.Security.AccessControl.RegistryRights]::TakeOwnership
  )
  if (-not $key) { throw "Chiave non trovata: HKLM:\$regPath" }

  $acl = $key.GetAccessControl()
  $admSid = New-Object System.Security.Principal.SecurityIdentifier([System.Security.Principal.WellKnownSidType]::BuiltinAdministratorsSid, $null)
  $admAcc = $admSid.Translate([System.Security.Principal.NTAccount])
  $acl.SetOwner($admAcc)
  $key.SetAccessControl($acl)

  $acl = $key.GetAccessControl()
  $rule = New-Object System.Security.AccessControl.RegistryAccessRule($admAcc, 'FullControl', 'ContainerInherit', 'None', 'Allow')
  $acl.SetAccessRule($rule)
  $key.SetAccessControl($acl)
  $key.Close()

  Remove-Item -Path "HKLM:\$regPath" -Recurse -Force
  Write-Host "`nChiave GracePeriod eliminata." -ForegroundColor Cyan
}
catch {
  Write-Error "Errore durante il reset del Grace Period: $($_.Exception.Message)"
  return
}

# Riavvio servizio RDP
try {
  Write-Host "Riavvio del servizio TermService..." -ForegroundColor Cyan
  Restart-Service -Name TermService -Force -ErrorAction Stop
  Start-Sleep -Seconds 5
} catch {
  Write-Warning "Impossibile riavviare TermService automaticamente. Potrebbe essere necessario un riavvio."
}

# Stato post-reset (prima del reboot)
$after = Get-GraceDays
Write-Host "`nGiorni di GRACE rimanenti (dopo reset): $after" -ForegroundColor Yellow

# --- OPZIONALE: riavvio del server ---
$reboot = Read-Host "Vuoi riavviare ORA il server per applicare completamente la modifica? (Y/N)"
if ($reboot -match '^(y|s)$') {
  Write-Host "`nIl server si riavvierà tra 30 secondi. Salva il lavoro aperto." -ForegroundColor Red
  shutdown.exe /r /t 30 /c "Riavvio per reset Grace Period RDS (solo LAB/TEST)" /f
  # In alternativa: Restart-Computer -Force
} else {
  Write-Host "`nNessun riavvio eseguito. Se il valore dei giorni non si aggiorna, riavvia manualmente." -ForegroundColor Cyan
}

Write-Host "`nOperazione completata (solo LAB/TEST)." -ForegroundColor Green