# Richiesta del vCenter all'utente
$vCenter = Read-Host "Inserisci il nome o l'indirizzo del vCenter"
Connect-VIServer -Server $vCenter


# Percorso output CSV
$outputCsv = "C:\Temp\vm_notes_export.csv"


# Recupero VM e costruzione dell'elenco
$vmData = Get-VM | ForEach-Object {
    [PSCustomObject]@{
        Name  = $_.Name
        Notes = $_.ExtensionData.Summary.Config.Annotation
    }
}


# Esportazione in CSV
$vmData | Export-Csv -Path $outputCsv -NoTypeInformation -Encoding UTF8


Write-Host "\nEsportazione completata. File generato: $outputCsv" -ForegroundColor Green


# Disconnessione dal vCenter
Disconnect-VIServer -Server $vCenter -Confirm:$false