# Richiesta del vCenter all'utente
$vCenter = Read-Host "Inserisci il nome o l'indirizzo del vCenter"
Connect-VIServer -Server $vCenter

# Percorso del file CSV
$csvPath = "C:\Temp\vm_info.csv"

# Importa i dati
$vms = Import-Csv -Path $csvPath

# Lista delle VM su cui è stato fatto append
$appendList = @()

# INIZIO del ciclo foreach
foreach ($entry in $vms) {
    $vmName = $entry.Name.Trim()
    $vm = Get-VM -Name $vmName -ErrorAction SilentlyContinue

    if (-not $vm) {
        Write-Host "VM non trovata, salto: $vmName" -ForegroundColor Yellow
        continue
    }

    # Mappatura con fallback
    $installationDate = if ($vm.ExtensionData.Config.CreateDate) { $vm.ExtensionData.Config.CreateDate } else { "N/A" }
    $requestor        = if ($entry.Team) { $entry.Team } else { "N/A" }
    $owner            = if ($entry.Owner) { $entry.Owner } else { "N/A" }
    $env              = if ($entry.Ambiente) { $entry.Ambiente } else { "N/A" }
    $os               = if ($entry.OS) { $entry.OS } else { "N/A" }
    $ticket           = if ($entry.Ticket) { $entry.Ticket } else { "N/A" }

    # Campo Role derivato da Descrizione + Descrizione Lunga
    $role1 = if ($entry.Descrizione) { $entry.Descrizione } else { "" }
    $role2 = if ($entry.'Descrizione Lunga') { $entry.'Descrizione Lunga' } else { "" }

    if ($role1 -and $role2) {
        $role = "$role1 - $role2"
    } elseif ($role1) {
        $role = $role1
    } elseif ($role2) {
        $role = $role2
    } else {
        $role = "N/A"
    }

    # Nuova sezione da aggiungere alle note
    $newSection = @"
---
Installation Date: $installationDate
Requestor: $requestor
Owner: $owner
Env: $env
Role: $role
O.S.: $os
Ticket: $ticket
"@.Trim()

    # Note attuali (se presenti)
    $currentNote = $vm.ExtensionData.Summary.Config.Annotation

    if ($currentNote) {
        # Append
        $combinedNote = $currentNote.Trim() + "`n`n" + $newSection
        $appendList += $vmName
        Write-Host "Note esistenti trovate: append effettuato su $vmName" -ForegroundColor Cyan
    } else {
        # Prima scrittura
        $combinedNote = $newSection
        Write-Host "Note scritte ex novo su: $vmName" -ForegroundColor Green
    }

    # Aggiorna il campo Notes
    Set-VM -VM $vm -Notes $combinedNote -Confirm:$false
} # ← QUESTA È LA GRAFFA DI CHIUSURA DEL foreach

# Disconnessione dal vCenter
Disconnect-VIServer -Server $vCenter -Confirm:$false

# Report finale
if ($appendList.Count -gt 0) {
    Write-Host "`nVM con note aggiornate in append:" -ForegroundColor Magenta
    $appendList | ForEach-Object { Write-Host "- $_" }
} else {
    Write-Host "`nNessuna VM con note preesistenti. Nessun append effettuato." -ForegroundColor Gray
}