#!/bin/bash
# Funzione per mostrare il banner
show_banner() {
    cat << "EOF"
##########################################################################################################################################################
##   ,---.      .-._            _,---.      ,----.              _,.---._                        ,---.                               .=-.-.  ,---.       ##
## .--.'  \    /==/ \  .-._ _.='.'-,  \  ,-.--` , \   _.-.    ,-.' , -  `.            _.-.    .--.'  \     .--.-. .-.-. .-.,.---.  /==/_ /.--.'  \      ##
## \==\-/\ \   |==|, \/ /, /==.'-     / |==|-  _.-` .-,.'|   /==/_,  ,  - \         .-,.'|    \==\-/\ \   /==/ -|/=/  |/==/  `   \|==|, | \==\-/\ \     ##
## /==/-|_\ |  |==|-  \|  /==/ -   .-'  |==|   `.-.|==|, |  |==|   .=.     |       |==|, |    /==/-|_\ |  |==| ,||=| -|==|-, .=., |==|  | /==/-|_\ |    ##
## \==\,   - \ |==| ,  | -|==|_   /_,-./==/_ ,    /|==|- |  |==|_ : ;=:  - |       |==|- |    \==\,   - \ |==|- | =/  |==|   '='  /==|- | \==\,   - \   ##
## /==/ -   ,| |==| -   _ |==|  , \_.' )==|    .-' |==|, |  |==| , '='     |       |==|, |    /==/ -   ,| |==|,  \/ - |==|- ,   .'|==| ,| /==/ -   ,|   ##
##/==/-  /\ - \|==|  /\ , \==\-  ,    (|==|_  ,`-._|==|- `-._\==\ -    ,_ /        |==|- `-._/==/-  /\ - \|==|-   ,   /==|_  . ,'.|==|- |/==/-  /\ - \  ##
##\==\ _.\=\.-'/==/, | |- |/==/ _  ,  //==/ ,     //==/ - , ,/'.='. -   .'         /==/ - , ,|==\ _.\=\.-'/==/ , _  .'/==/  /\ ,  )==/. /\==\ _.\=\.-'  ##
## `--`        `--`./  `--``--`------' `--`-----`` `--`-----'   `--`--''           `--`-----' `--`        `--`..---'  `--`-`--`--'`--`-`  `--`          ##
##                                                                                                                                                      ##
##    Sono Angelo Lauria e ho una passione per l’automazione e lo scripting, soprattutto con Bash e PowerShell.                                         ##
##    Il mio viaggio nello scripting è iniziato per curiosità, spinto dal desiderio di rendere più efficienti i processi quotidiani.                    ##
##    Oggi continuo ad affrontare ogni nuova sfida come un'opportunità per crescere e migliorare.                                                       ##
##    Credo che l’informatica sia un campo in continua trasformazione, e il bello sta proprio nell’essere sempre pronti a evolversi insieme a essa.     ##
##                                                                                                                                                      ##
##########################################################################################################################################################
EOF
}
show_banner

# Richiesta di credenziali e informazioni
echo "Inserire la password dell'utente root:"
read -s root_db

echo "Inserire il nome del database syspass_db:"
read syspass_db

echo "Inserire il nome utente per il database syspass_db:"
read syspass_user

echo "Inserire la password per l'utente del database syspass_db:"
read -s syspass_user_pw

##################################
locale-gen
update-locale LANG=en_US.UTF-8
##################################

# Verifica se PHP è installato
if ! [ -x "$(command -v php)" ]; then
  add-apt-repository -y ppa:ondrej/php
  apt update
  apt install libapache2-mod-php7.4 php7.4 php7.4-mysql php7.4-pdo php7.4-cgi php7.4-cli php7.4-common php7.4-gd php7.4-json php7.4-readline php7.4-curl php7.4-intl php7.4-ldap php7.4-xml php7.4-mbstring php7.4-zip git unzip -y
fi
sleep 5

# Verifica se Apache è installato
if [ -x "$(command -v apache2)" ]; then
    echo "Apache è già installato"
else
    echo "Apache non è installato. Installazione in corso..."
    apt update
    apt install apache2 -y
fi
sleep 5

# Verifica se MariaDB è installato
if ! [ -x "$(command -v mysql)" ]; then
  echo "MariaDB non è installato. Installazione in corso..."
  apt update
  apt install mariadb-server mariadb-client -y
  echo -e "$root_db\nY\n$root_db\n$root_db\nY\nY\nY\nY" | mysql_secure_installation
else
  echo "MariaDB è già installato. Procedo con la verifica del database."
fi
sleep 5

# Verifica se il database esiste
if echo "SHOW DATABASES;" | mysql -u root -p$root_db | grep -q "$syspass_db"; then
  echo "Il database $syspass_db esiste. Continuo con l'installazione."
else
  echo "Il database $syspass_db non esiste. Creazione in corso..."
  echo "CREATE DATABASE $syspass_db;" | mysql -u root -p$root_db
  echo "Il database $syspass_db è stato creato."
  echo "CREATE USER '$syspass_user'@'localhost' IDENTIFIED BY '$syspass_user_pw';" | mysql -u root -p$root_db
  echo "L'utente $syspass_user è stato creato."
  echo "GRANT ALL PRIVILEGES ON $syspass_db.* TO '$syspass_user'@'localhost';" | mysql -u root -p$root_db
  echo "I permessi sono stati assegnati."
  echo "FLUSH PRIVILEGES;" | mysql -u root -p$root_db
  echo "I privilegi sono stati ricaricati."
fi
sleep 5

# Clona il repository sysPass
git clone https://github.com/nuxsmin/sysPass.git
mv sysPass /var/www/html/syspass/
chown -R www-data:www-data /var/www/html/syspass
chmod -R 750 /var/www/html/syspass/app/{config,backup}

# Configura Git per la directory "safe"
git config --global --add safe.directory /var/www/html/syspass

# Scarica e installa Composer manualmente
echo "Scaricando e installando Composer..."
cd /var/www/html/syspass
curl -sS https://getcomposer.org/installer | php
mv composer.phar /usr/local/bin/composer
export COMPOSER_ALLOW_SUPERUSER=1
php /usr/local/bin/composer install --no-dev
sleep 5

# Configura Apache
a2enmod rewrite
systemctl restart apache2
sleep 5
show_banner

# Verifica installazione
if [ -d "/var/www/html/syspass" ]; then
  echo "sysPass è stato installato correttamente."
else
  echo "Errore durante l'installazione di sysPass."
fi
