#!/bin/bash

# Funzione per mostrare il banner
show_banner() {
    cat << "EOF"
##########################################################################################################################################################
##   ,---.      .-._            _,---.      ,----.              _,.---._                        ,---.                               .=-.-.  ,---.       ##
## .--.'  \    /==/ \  .-._ _.='.'-,  \  ,-.--` , \   _.-.    ,-.' , -  `.            _.-.    .--.'  \     .--.-. .-.-. .-.,.---.  /==/_ /.--.'  \      ##
## \==\-/\ \   |==|, \/ /, /==.'-     / |==|-  _.-` .-,.'|   /==/_,  ,  - \         .-,.'|    \==\-/\ \   /==/ -|/=/  |/==/  `   \|==|, | \==\-/\ \     ##
## /==/-|_\ |  |==|-  \|  /==/ -   .-'  |==|   `.-.|==|, |  |==|   .=.     |       |==|, |    /==/-|_\ |  |==| ,||=| -|==|-, .=., |==|  | /==/-|_\ |    ##
## \==\,   - \ |==| ,  | -|==|_   /_,-./==/_ ,    /|==|- |  |==|_ : ;=:  - |       |==|- |    \==\,   - \ |==|- | =/  |==|   '='  /==|- | \==\,   - \   ##
## /==/ -   ,| |==| -   _ |==|  , \_.' )==|    .-' |==|, |  |==| , '='     |       |==|, |    /==/ -   ,| |==|,  \/ - |==|- ,   .'|==| ,| /==/ -   ,|   ##
##/==/-  /\ - \|==|  /\ , \==\-  ,    (|==|_  ,`-._|==|- `-._\==\ -    ,_ /        |==|- `-._/==/-  /\ - \|==|-   ,   /==|_  . ,'.|==|- |/==/-  /\ - \  ##
##\==\ _.\=\.-'/==/, | |- |/==/ _  ,  //==/ ,     //==/ - , ,/'.='. -   .'         /==/ - , ,|==\ _.\=\.-'/==/ , _  .'/==/  /\ ,  )==/. /\==\ _.\=\.-'  ##
## `--`        `--`./  `--``--`------' `--`-----`` `--`-----'   `--`--''           `--`-----' `--`        `--`..---'  `--`-`--`--'`--`-`  `--`          ##
##                                                                                                                                                      ##
##    Sono Angelo Lauria e ho una passione per l’automazione e lo scripting, soprattutto con Bash e PowerShell.                                         ##
##    Il mio viaggio nello scripting è iniziato per curiosità, spinto dal desiderio di rendere più efficienti i processi quotidiani.                    ##
##    Oggi continuo ad affrontare ogni nuova sfida come un'opportunità per crescere e migliorare.                                                       ##
##    Credo che l’informatica sia un campo in continua trasformazione, e il bello sta proprio nell’essere sempre pronti a evolversi insieme a essa.     ##
##                                                                                                                                                      ##
##########################################################################################################################################################
EOF
}

# Variabili per l'installazione
default_teampass_dir="/var/www/html/teampass"
default_secure_dir="/var/teampass"
default_db_name="teampass_db"
default_db_user="teampass_user"
default_db_password="teampass_password"

# Funzione per leggere input con valori predefiniti
read_with_default() {
    local prompt="$1"
    local default="$2"
    read -p "$prompt [$default]: " input
    echo "${input:-$default}"
}
# Inizio script
show_banner

# Richiesta delle informazioni
teampass_dir=$(read_with_default "Inserire il percorso di installazione di TeamPass" "$default_teampass_dir")
secure_dir=$(read_with_default "Inserire il percorso sicuro per la chiave di crittografia" "$default_secure_dir")
db_name=$(read_with_default "Inserire il nome del database" "$default_db_name")
db_user=$(read_with_default "Inserire il nome utente del database" "$default_db_user")
db_password=$(read_with_default "Inserire la password per l'utente del database" "$default_db_password")

# Aggiornamento del sistema e installazione dei pacchetti necessari
echo "Aggiornamento del sistema e installazione dei pacchetti necessari..."
apt update && apt upgrade -y
apt install -y apache2 mariadb-server php libapache2-mod-php php-mysql php-mbstring php-xml php-curl php-zip php-intl php-bcmath php-gmp php-gd unzip git vim

# Configurazione di MariaDB
echo "Configurazione del database MariaDB..."
systemctl start mariadb
mysql -u root <<EOF
CREATE DATABASE IF NOT EXISTS $db_name;
CREATE USER IF NOT EXISTS '$db_user'@'localhost' IDENTIFIED BY '$db_password';
GRANT ALL PRIVILEGES ON $db_name.* TO '$db_user'@'localhost';
FLUSH PRIVILEGES;
EOF

# Scaricamento di TeamPass
echo "Scaricamento di TeamPass dal repository GitHub..."
mkdir -p "$teampass_dir"
cd /tmp
git clone https://github.com/nilsteampassnet/TeamPass.git
echo "Copia dei file di TeamPass nella directory di installazione..."
cp -R TeamPass/* "$teampass_dir"
chown -R www-data:www-data "$teampass_dir"
chmod -R 750 "$teampass_dir"

# Configurazione della directory sicura
echo "Creazione della directory sicura per la chiave di crittografia..."
mkdir -p "$secure_dir"
chown www-data:www-data "$secure_dir"
chmod 700 "$secure_dir"

# Configurazione di Apache
echo "Configurazione di Apache per TeamPass..."
cat <<EOL > /etc/apache2/sites-available/teampass.conf
<VirtualHost *:80>
    DocumentRoot $teampass_dir
    <Directory $teampass_dir>
        AllowOverride All
        Require all granted
    </Directory>
    ErrorLog \${APACHE_LOG_DIR}/teampass_error.log
    CustomLog \${APACHE_LOG_DIR}/teampass_access.log combined
</VirtualHost>
EOL
a2ensite teampass.conf
a2enmod rewrite
systemctl restart apache2
# Inizio script
show_banner
# Configurazione finale
echo "TeamPass è stato installato con successo. Completare la configurazione accedendo all'URL del server Apache http://<server_ip>/teampass."
